import logging

LOGGER = logging.getLogger(__name__)

SOLOMON_API_URL_PRODUCTION = 'http://solomon.yandex.net'
SOLOMON_API_URL_PRESTABLE = 'http://solomon-prestable.yandex.net'
SOLOMON_PROJECT = 'yabs_stat'


class YabsStatSolomonClientBase(object):
    def __init__(self, service, cluster, is_production=False, token=None):
        import solomon

        url = SOLOMON_API_URL_PRODUCTION if is_production else SOLOMON_API_URL_PRESTABLE
        self._reporter = solomon.BasePushApiReporter(
            project=SOLOMON_PROJECT,
            cluster=cluster,
            service=service,
            url=url,
            auth_provider=solomon.OAuthProvider(token) if token else None,
        )
        LOGGER.info(
            'Solomon client is configured with url=%s, project=%s, cluster=%s, service=%s',
            url, SOLOMON_PROJECT, cluster, service,
        )

    def push_metrics(self, sensors, values, labels, datetime):
        LOGGER.info('Started sending %d values to solomon', len(values))
        self._reporter.set_value(sensors, values, labels, ts_datetime=datetime)
        LOGGER.info('Finished sending data to solomon')
