import datetime

DEFAULT_BATCH_SIZE = 100


def get_hanging_tasks_by_status(sb_client, task_type, status, ttl, batch_size=DEFAULT_BATCH_SIZE):
    threshold_time = datetime.datetime.utcnow() - datetime.timedelta(seconds=ttl)

    offset = 0

    while True:
        read_params = {
            'type': task_type,
            'status': status,
            'limit': batch_size,
            'offset': offset,
            'children': True,
            'order': '-id',
            'updated': '%s..%s' % ('1970-01-01T00:00:00.000000', threshold_time.isoformat())
        }
        res = sb_client.task.read(read_params)
        if len(res['items']) == 0:
            break
        yield res['items']
        offset += batch_size


def kill_tasks(sb_client, task_ids):
    """ Returns tuple:
        - succeeded: list of ids that were successfully marked as deleted
        - failed: dict, key: value, key is status of failure, value is list of task ids
    """
    def sort_results(results):
        succeeded_ids = []
        failed = {}
        for res in results:
            if res['status'] == 'SUCCESS':
                succeeded_ids.append(res['id'])
            else:
                failed[res['id']] = {'status': res['status'], 'message': res.get('message', '')}

        return succeeded_ids, failed

    del_result = sb_client.batch.tasks['delete'].update(task_ids)
    return sort_results(del_result)
