def GetFeedbackStatistics(bs_ssp_feedback_table, time_from, time_to, google_ssp_id):
    return '''
        SELECT
            buyer_creative_id,
            creative_status_code,
            sum(1) as event_count
        FROM
            range(`{bs_ssp_feedback_table}`, `{time_from}`, `{time_to}`)
        WHERE
            sspid = {google_ssp_id}
        GROUP BY
            buyer_creative_id,
            creative_status_code
        ORDER BY
            event_count desc
    '''.format(bs_ssp_feedback_table=bs_ssp_feedback_table, time_from=time_from, time_to=time_to, google_ssp_id=google_ssp_id)


def GetAllMalwareOrderByDomain(bs_ssp_feedback_table, bs_dsp_table, time_from, time_to, google_ssp_id):
    return '''
        SELECT
            distinct(dsp.campaignid) as OrderID
        FROM
            range(`{bs_ssp_feedback_table}`, `{time_from}`, `{time_to}`) as feedback
        INNER JOIN
            range(`{bs_dsp_table}`,  `{time_from}`, `{time_to}`) as dsp
        ON feedback.bidreqid = cast(dsp.bidreqid as Int64)
        WHERE
            dsp.dspid = '1' AND dsp.win = '1' AND dsp.countertype = '0'
        AND
            feedback.sspid = {google_ssp_id}
        AND
            feedback.creative_status_code in (6, 10)
        AND
            feedback.buyer_creative_id like '%domain%'
    '''.format(bs_ssp_feedback_table=bs_ssp_feedback_table, bs_dsp_table=bs_dsp_table, time_from=time_from, time_to=time_to, google_ssp_id=google_ssp_id)


def GetBlackList(black_list_table, google_ssp_id):
    return '''
        SELECT
            OrderID as OrderID,
            Ticket as Ticket,
            UpdateTime as UpdateTime
        FROM
            `{black_list_table}`
        WHERE
            SSPID = {google_ssp_id}
    '''.format(black_list_table=black_list_table, google_ssp_id=google_ssp_id)


def GetDomainsRequest(bad_orders):
    return '''
        select
            OrderID,
            DomainID
        from `//home/yabs-cs/export/YTBanner` as b
        where OrderID in ({bad_orders})
        group by
            OrderID,
            if (DomainID != 0, DomainID, TargetDomainID) as DomainID
    '''.format(bad_orders=','.join(str(order) for order in bad_orders))
