import time


def GetTopMediaOrdersRequest(bs_chevent_log_table, order_info_table, wl_table, placeid,
                             heavy_creative_id, sspid=0, top_limit=20000,
                             skip_already_added_orders=True):

    creative_id_filter = ""
    if heavy_creative_id is not None:
        creative_id_filter = "and CHEVENT.creativeid not in ({})".format(heavy_creative_id)

    stat_start_time = time.time() - 30*24*3600

    join_with_white_list = '''
        left only join $wl_filtered as OrderWhiteList on OrderWhiteList.OrderID = Oi.OrderID
    ''' if skip_already_added_orders else ''

    return '''
    $wl_filtered = (
        select OrderID
        from `{wl_table}`
        where SSPID = {sspid} or SSPID = 0
    );

    $banners = (
        select
            OrderID,
            DomainID
        from `//home/yabs-cs/export/YTBanner`
        group by
            if (DomainID != 0, DomainID, TargetDomainID) as DomainID,
            OrderID
    );

    $whitelisted_clients = (
        select
        distinct oi.ClientID as ClientID
        from `{wl_table}` as wl
            left join `{order_info_table}` as oi using(OrderID)
    );

    $orders_stat = (
        select OrderID, min(UpdateTime) as min_time, max(UpdateTime) as max_time, sum(Cost) as summ
        from `//home/yabs/stat/OrderStatDay` as stat
        where UpdateTime > {stat_start_time}
        group by OrderID
        having count(UpdateTime) > 15 and sum(Cost) > 1000000 -- 15 stat days and spent cost more than 1ye
    );
    
    $mobile_apps = (
        select
        distinct OrderID as OrderID
        from `//home/yabs-cs/export/Banners`
        where IsMobileApp
    );

        select F.OrderID
        from (
            select Ch.OrderID as OrderID, Ch.Esum as Esum
            from (
                    select Ch.OrderID as OrderID, Ch.Esum as Esum
                    from (
                        select CHEVENT.orderid as OrderID,
                        sum(cast(CHEVENT.eventcost as Int64)) as Esum
                        from {bs_chevent_log_table} as CHEVENT
                        where CHEVENT.fraudbits = '0'
                        and CHEVENT.eventflags = '0'
                        and CHEVENT.options like '%flat-page%'
                        and CHEVENT.options like '%dsp%'
                        -- and CHEVENT.options not like '%mobile-app%'
                        and CHEVENT.placeid in ({placeid})
                        and (
                            CHEVENT.producttype like '%media-smart%'
                            or CHEVENT.producttype like '%media-creative%'
                            or CHEVENT.producttype like '%media-image%'
                            or CHEVENT.producttype like '%direct%'
                            or CHEVENT.producttype = 'video-creative'
                            or CHEVENT.producttype = 'video-creative-reach'
                        )
                        {heavy_creative_id_cond}
                        group by orderid
                        order by -Esum
                    ) as Ch
                ) as Ch
            inner join
                `{order_info_table}` as Oi
                on cast(Ch.OrderID as UInt32) = Oi.OrderID
            {join_with_white_list}
            -- left join
            --    `//home/yabs/dict/AutoBudgetOrder` as Oa
            --    on Oi.OrderID = Oa.OrderID
            left join
                $orders_stat as OrderStat on Oi.OrderID = OrderStat.OrderID
            left join
                $whitelisted_clients as WhiteListedClients on WhiteListedClients.ClientID = Oi.ClientID
            left join
                $mobile_apps as MobileApps on MobileApps.OrderID = Oi.OrderID
            where
                Oi.OrderType in (1, 6)
                -- and (Oa.OrderID is NULL OR Oa.LimitWeek = 0 OR Oa.LimitWeek > 50000000) -- check against spam (low autobudget level)
                and (
                    OrderStat.OrderID is not NULL
                    or
                    WhiteListedClients.ClientID is not NULL
                    or
                    Oi.ContentTypeReach = true
                    or
                    MobileApps.OrderID is not NULL
                )
            order by
                -Esum
            limit {top_limit}
        ) as F
    '''.format(bs_chevent_log_table=bs_chevent_log_table, order_info_table=order_info_table,
               wl_table=wl_table, top_limit=top_limit, placeid=placeid,
               heavy_creative_id_cond=creative_id_filter, stat_start_time=stat_start_time, sspid=sspid,
               join_with_white_list=join_with_white_list)


def GetHeavyCreativeIDList(weight=50000):
    return '''
       SELECT
           CreativeID
       FROM
           `//home/yabs/dict/DSPCreative`
       WHERE
           Data like '%getClickMacro%'
           and length(Data) > {weight}
    '''.format(weight=weight)


def GetWhiteListRequest(wt_list_table, ssp_id):
    return '''
        select OrderID
        from `{wt_list_table}`
        where SSPID = {ssp_id}
            or SSPID = 0
    '''.format(wt_list_table=wt_list_table, ssp_id=ssp_id)
