from datetime import datetime, timedelta

DEFAULT_COUNTRY_LIST = ['TUR', 'GBR', 'DEU']  # country from google request
DEFAULT_COUNTER_ID_LIST = [64681882, 42639109, 85822663, 23731303, 21279832, 86821095, 34273590, 33008324]  # target campaigns


def get_profile_uniq_ids_query():
    query_text = '''
        PRAGMA File('bigb.so', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={{"released":"stable"}}');
        PRAGMA udf('bigb.so');
        PRAGMA AnsiInForEmptyOrNullableItemsCollections;
        
        $date = '{date}';
        $country_list = {country_list};
        $counter_ids = {counter_ids};
        
        $has_offer = ($profile) -> {{
            return ListAny(ListMap($profile.offers, ($offer) -> {{ return ListLength($counter_ids) <= 0 or $offer.counter_id in $counter_ids; }}));
        }};
        
        $daily_uniq_ids = (
            SELECT DISTINCT
            CASE
                WHEN gaid != "" THEN 'GAID'
                WHEN idfa != "" THEN 'IDFA'
                ELSE "UNKNOWN"
            END as id_type,
            CASE
                WHEN gaid != "" THEN gaid
                WHEN idfa != "" THEN idfa
                ELSE ""
            END as user_id,
            CASE
                WHEN gaid != "" THEN 'gaid/' || gaid
                WHEN idfa != "" THEN 'idfa/' || idfa
                ELSE ""
            END as bigb_user_id,
            FROM
                range(`logs/bs-rtb-log/1d`, $date, $date)
            WHERE
                (ListLength($country_list) <= 0 or Dsv::Parse(queryargs, '&')['1033'] in $country_list) and
                sspid == '17298340' and (gaid != "" or idfa != "")
        );
        
        SELECT ids.id_type, ids.user_id
        FROM
            RANGE('home/bigb/production/public/profiles', 'PublicProfilesDump_' || $date || 'T00:00:00+03:00', 'PublicProfilesDump_' || $date || 'T12:00:00+03:00') as profiles
        JOIN
            $daily_uniq_ids as ids
        ON ids.bigb_user_id == profiles.UniqID
        WHERE $has_offer(Bigb::ParseProfile(SerializedProto));
    '''.format(date=(datetime.today() - timedelta(1)).strftime('%Y-%m-%d'), counter_ids=DEFAULT_COUNTER_ID_LIST,
               country_list=DEFAULT_COUNTRY_LIST)

    return query_text
