#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time

from sandbox import sdk2

from .yql_requests import get_new_order_ids_query

from sandbox.projects.yabs.ssp.base_fill_whitelist.YabsServerFillWhiteList import BaseYabsServerFillWhiteList


class YabsServerFillSamsungWhiteList(BaseYabsServerFillWhiteList, sdk2.Task):
    class Parameters(BaseYabsServerFillWhiteList.Parameters):
        with BaseYabsServerFillWhiteList.Parameters.common_params() as common_params:
            sspid = sdk2.parameters.Integer('Samsung SSPID ', default=64465048, required=True)
            white_ticket = sdk2.parameters.String('Samsung WhiteScript Task Ticket ', default='BSDEV-79091', required=True)

    def run_queries(self):
        self.run_yql_query(get_new_order_ids_query(
            wl_table=self.Parameters.wt_table_path,
            chevent_log_table=self.Context.bs_chevent_log_table,
            ssp_id=self.Parameters.sspid,
            top_count=self.Parameters.top_count
        ), self.yql_token, self.Parameters.priority_cluster, 'new_order_ids')

    def get_data_from_yql(self):
        self.new_orders = [order['order_id'] for order in self.get_yql_results('new_order_ids')]

    def fill_white_list(self):
        self.write_white_list()

    def get_solomon_data(self):
        current_time = int(time.time())
        return {
            'sensors': [
                {
                    'labels': {'SamsungWhiteListStatistics': 'AddedOrders{}'.format(cluster.capitalize())},
                    'ts': current_time,
                    'value': int(self.added_orders_by_cluster.get(cluster, 0)),
                }
                for cluster in self.Context.yt_clusters
            ]
        }
