def get_new_order_ids_query(wl_table, chevent_log_table, ssp_id, top_count):
    return """
        $wl = (
            SELECT
                OrderID
            FROM `{wl}`
            WHERE SSPID = {ssp_id} OR SSPID = 0
        );

        SELECT
            CAST(chevent.orderid AS UInt64) AS order_id,
            SUM(CAST(chevent.eventcost AS Int64)) as cost_sum,
        FROM {chevent} AS chevent
        LEFT ONLY JOIN $wl AS wl ON wl.OrderID = CAST(chevent.orderid AS UInt64)
        WHERE
            producttype == 'direct'
            AND placeid IN ('542', '1542')
            AND chevent.fraudbits == '0'
            AND chevent.eventflags == '0'
            AND chevent.options LIKE '%flat-page%'
            AND chevent.options LIKE '%dsp%'
            AND chevent.options LIKE '%mobile-app%'
        GROUP BY chevent.orderid
        ORDER BY cost_sum DESC
        LIMIT {top_count}
    """.format(wl=wl_table, chevent=chevent_log_table, ssp_id=ssp_id, top_count=top_count)
