import os

from parameters import SsrSUTParameters
from sandbox import sdk2
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.ssr.renderer_sut import SsrSUT
from sandbox.projects.yabs.ssr.renderer_sut.adapters.interface import SsrSUTAdapterInterface
from sandbox.sandboxsdk.paths import get_logs_folder


class SsrSUTSandboxAdapter(SsrSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return SsrSUTParameters

    def get_pcode_resource_path(self):
        return self.sync_resource(self.parameters.pcode_package_resource)

    def get_node_relpath(self):
        return self.parameters.pcode_package_resource.node_relpath

    def get_logs_dir(self):
        return get_logs_folder()

    def get_work_dir(self):
        return os.getcwd()

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_executable_res_id = self.parameters.cache_daemon_stub_resource.cache_daemon_res_id
        return self.sync_resource(cache_daemon_executable_res_id)

    def get_cache_daemon_key_headers(self):
        return self.parameters.cache_daemon_stub_resource.key_header

    def get_ports_map(self):
        return self.parameters.ports_map

    def get_tokens(self):
        owner = self.task_instance.owner
        return {
            'SANDBOX_AUTH_TOKEN': sdk2.Vault.data(owner, self.parameters.sandbox_token_vault_name),
            'YA_TOKEN': sdk2.Vault.data(owner, self.parameters.ya_token_vault_name),
            'YT_TOKEN': sdk2.Vault.data(owner, self.parameters.yt_token_vault_name),
        }

    def get_web_pcode_micro_package_id(self):
        return (
            self.parameters.web_pcode_micro_package_resource.id
            if self.parameters.web_pcode_micro_package_resource
            else 0
        )

    def create_module(self):
        return SsrSUT(self)
