from abc import ABCMeta, abstractmethod


class SsrSUTAdapterInterface(object):

    __metaclass__ = ABCMeta

    @abstractmethod
    def get_pcode_resource_path(self):
        pass

    @abstractmethod
    def get_node_relpath(self):
        pass

    @abstractmethod
    def get_logs_dir(self):
        pass

    @abstractmethod
    def get_work_dir(self):
        pass

    @abstractmethod
    def get_cache_daemon_stub_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_executable_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_key_headers(self):
        pass

    @abstractmethod
    def get_ports_map(self):
        pass

    @abstractmethod
    def get_tokens(self):
        pass

    @abstractmethod
    def get_web_pcode_micro_package_id(self):
        pass

    @abstractmethod
    def get_apphost_mode(self):
        pass
