from sandbox import sdk2
from sandbox.projects.sandbox_ci.resources.generated import WebPcodeMicroPackage
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_CACHE_DAEMON_STUB_DATA
from sandbox.projects.yabs.ssr.resources import BsSsrPcodeResource


DEFAULT_PORTS_MAP = {
    'apphost_admin_port': 10090,
    'renderer_admin_port': 3221,
    'renderer_port': 3222,
    'cache_daemon_ports': {
        'rtb': 10050,
    },
}


class SsrSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Ssr SUT parameters:') as sut_group:
        pcode_package_resource = sdk2.parameters.Resource(
            'Resource with PCODE content',
            resource_type=BsSsrPcodeResource,
        )
        web_pcode_micro_package_resource = sdk2.parameters.Resource(
            'WEB_PCODE_MICRO_PACKAGE resource to run in renderer',
            resource_type=WebPcodeMicroPackage,
        )
        cache_daemon_stub_resource = sdk2.parameters.Resource(
            'Cache daemon stub',
            resource_type=YABS_SERVER_CACHE_DAEMON_STUB_DATA,
        )
        apphost_mode = sdk2.parameters.String(
            "Apphost mode (agent or arcadia)",
            default='agent',
        )
        ports_map = sdk2.parameters.JSON('Ports services will be run on', default_value=DEFAULT_PORTS_MAP)

    with sdk2.parameters.Group('Tokens parameters:') as tokens_group:
        ya_token_vault_name = sdk2.parameters.String(
            "YA token vault name",
            default='ssr_tests_ya_token',
        )
        yt_token_vault_name = sdk2.parameters.String(
            "YT token vault name",
            default='ssr_tests_yt_token',
        )
        sandbox_token_vault_name = sdk2.parameters.String(
            "Sandbox token vault name",
            default='ssr_tests_sandbox_token',
        )
