var fs = require('fs'),
    HtmlDiffer = require('html-differ').HtmlDiffer,
    logger = require('html-differ/lib/logger');

var args = process.argv.slice(2);

var preHtml = fs.readFileSync(args[0], 'utf-8'),
    testHtml = fs.readFileSync(args[1], 'utf-8');

var options = {
        ignoreAttributes: [],
        compareAttributesAsJSON: [],
        ignoreWhitespaces: true,
        ignoreComments: true,
        ignoreEndTags: false,
        ignoreDuplicateAttributes: false
    };

var htmlDiffer = new HtmlDiffer(options);

var diff = htmlDiffer.diffHtml(preHtml, testHtml),
    diffText = logger.getDiffText(diff, { charsAroundDiff: args[3] });

fs.writeFile(args[2], diffText, 'utf-8', function (err) {
    if (err) return console.log(err);
});
