import textwrap


_YT_PROXY = 'hahn'


def make_ssr_ammo_query(work_prefix, response_dump_prefix, handlers, custom_headers):
    """
    Query that prepares list of ssr requests and responses
    """
    return textwrap.dedent(
        """
        USE {yt_proxy};

        $work_prefix = "{work_prefix}";
        $response_dump_prefix = "{response_dump_prefix}";

        $handlers = {handlers};
        $custom_headers = {custom_headers};

        $make_custom_header = ($tuple) -> {{
            return cast($tuple.0 as string) || ": " || cast($tuple.1 as string) || "\\r\\n";
        }};

        $custom_headers = String::JoinFromList(ListMap($custom_headers, $make_custom_header), "");

        $make_response = ($status, $headers, $body) -> {{
            $status =
            "HTTP/1.1 " || cast($status as String) ||
            if($status == 200, " Ok", " Not_Ok") || "\\r\\n";

            $response_headers = $headers || $custom_headers;
            $response = $status || $response_headers || "\\r\\n" || $body;
            return $response;
        }};


        $result_dump_request = $response_dump_prefix || "/primary_ammo/0/request";
        $request = (
            select
                RequestID,
                Request,
                Handler
            from $result_dump_request
        );

        $result_dump_response = $response_dump_prefix || "/primary_ammo/0/response";
        $response = (
            select
                RequestID as `x-yabs-ssr-req-id`,
                Response,
                Headers,
                HttpCode,
                RequestIDBinary as RequestID
            from $result_dump_response
        );

        $merged = (
            select
                resp.RequestID as RequestID,
                resp.HttpCode as HttpStatus,
                req.Request as Request,
                resp.Headers as Headers,
                resp.Response as Response,
                req.Handler as Handler,
                "rtb" as Tag,
                resp.`x-yabs-ssr-req-id` as `x-yabs-ssr-req-id`
            from
                $request as req
            join
                $response as resp
            on
                (req.RequestID == resp.RequestID)
            where
                Handler in $handlers
        );

        $output = $work_prefix || "/output";

        INSERT INTO $output WITH TRUNCATE
        select *
        from
        (
            select
                `x-yabs-ssr-req-id` as GraphID,
                RequestID,
                CAST(null as Uint32) as HttpStatus,
                Request,
                CAST(null as String) as Response,
                Handler,
                CAST(null as String) as Tag,
                CAST(`x-yabs-ssr-req-id` as Uint64) as `x-yabs-ssr-req-id`
            from
                $merged
            union all
            select
                `x-yabs-ssr-req-id` as GraphID,
                RequestID,
                HttpStatus,
                CAST(null as String) as Request,
                $make_response(HttpStatus, Headers, Response) as Response,
                CAST(null as String) as Handler,
                Tag,
                CAST(`x-yabs-ssr-req-id` as Uint64) as `x-yabs-ssr-req-id`
            from
                $merged
        )
        order by
            `x-yabs-ssr-req-id`;
        COMMIT;
    """
    ).format(
        yt_proxy=_YT_PROXY,
        work_prefix=work_prefix,
        response_dump_prefix=response_dump_prefix,
        handlers=handlers,
        custom_headers=custom_headers,
    )
