from sandbox import sdk2
from sandbox.common.types.misc import DnsType
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import (
    AmmoRequestlogModuleGeneralSandboxAdapter,
)
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.task_factory.simple_shoot_task import factory as simple_shoot_task_factory
from sandbox.projects.yabs.qa.yt_uploader_module.adapters.sandbox import ShootResultsYtUploaderGenericSandboxAdapter
from sandbox.projects.yabs.ssr.resources import BsSsrResponseDump
from sandbox.projects.yabs.ssr.pcode_graph_sut.adapters.sandbox import PCodeGraphSUTSandboxAdapter


CONTAINER_RESOURCE = 2090878873


class AmmoRequestlogWithRepeatedQueryargsAdapter(AmmoRequestlogModuleGeneralSandboxAdapter):
    def __init__(self, parameters, task_instance):
        AmmoRequestlogModuleGeneralSandboxAdapter.__init__(
            self, parameters, task_instance, allow_repeated_queryargs=True
        )


class PCodeGraphSimpleShootTask(
    simple_shoot_task_factory(
        PCodeGraphSUTSandboxAdapter,
        AmmoRequestlogWithRepeatedQueryargsAdapter,
        DolbiloModuleSandboxAdapter,
        BsSsrResponseDump,
        'PCODE_GRAPH',
        ShootResultsYtUploaderGenericSandboxAdapter,
    )
):
    class Requirements(sdk2.Requirements):
        container_resource = CONTAINER_RESOURCE
        dns = DnsType.DNS64
