import logging
import subprocess


def run_command(command, verbose=True, stderr=None):
    if verbose:
        logging.info("Running command: %s", command)
    try:
        result = subprocess.check_output(command, shell=True, stderr=stderr)
        if verbose:
            logging.info(result)
        return result
    except subprocess.CalledProcessError as e:
        logging.error("Command %s failed, here its output:\n%s", command, e.output)
        raise
