from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import logging

TMP_TABLE_NAME_SRC = 'ApcTmpSrc'
TMP_TABLE_NAME_DST = 'ApcTmpDst'


class YabsApcTableForDistribution(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        token_vault_name = sdk2.parameters.String("SR-Robot Token Vault Name", default="token_static_rank_robot", required=True)
        apc_table_path = sdk2.parameters.String("Path to table with APC results", default="//home/yabs-cs-preprod/bogginat/StaticRankApcFeature", required=True)
        cluster = sdk2.parameters.String("Cluster", default="hahn", required=True)
        tmp_apc_table_dir = sdk2.parameters.String("YT dir for calculations", default="//home/bs/", required=True)
        tmp_apc_table_path = sdk2.parameters.String("YT path for calculations", default="users/bogginat/", required=True)
        days_stats = sdk2.parameters.String("Days to count statistics", default=20, required=True)
        resource_id = sdk2.parameters.Integer("Resource id of the apc_collector binary file", default=778972640, required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
        )

    def yt_connect(self, yt_cluster):
        import yt.wrapper as yt

        logging.info("Try connect to " + str(yt_cluster))
        try:
            cfg = {
                "tabular_data_format": yt.JsonFormat(control_attributes_mode="row_fields"),
                "detached": False,
                "token": self.yql_token,
                "proxy": {"url": yt_cluster},
            }
            ytc = yt.YtClient(config=cfg)
            logging.info("Succesfully connected to {}".format(yt_cluster))

            return ytc
        except:
            logging.info("Can`t connect to {}".format(yt_cluster))
            return None

    def run_calculations(self):
        logging.info("Started collecting statistics")
        env = {}
        env['YT_TOKEN'] = self.yql_token
        env['YQL_TOKEN'] = env['YT_TOKEN']
        out, err = run_process([
            str(self.resource.path),
            "--table={}".format(self.Parameters.tmp_apc_table_path + TMP_TABLE_NAME_SRC),
            "--dsttable={}".format(self.Parameters.tmp_apc_table_path + TMP_TABLE_NAME_DST),
            "--days={}".format(self.Parameters.days_stats),
        ], shell=True, check=False, wait=False, outs_to_pipe=True, environment=env).communicate()
        out, err = out.decode(), err.decode()
        logging.info("OUT: {}".format(out))
        logging.info("ERR: {}".format(err))
        logging.info("Ended collecting statistics")

    def get_data_from_tables(self):
        logging.info("Started getting data from tmp tables")
        self.apc_raws = list(self.ytc.read_table(self.Parameters.tmp_apc_table_dir + self.Parameters.tmp_apc_table_path + TMP_TABLE_NAME_DST))
        logging.info(self.apc_raws)
        logging.info("Ended getting data from tmp tables")

    def fill_apc_table(self):
        self.apc = []
        for raw in self.apc_raws:
            self.apc.append({'BannerID': int(raw.get('key')), 'APC': float(raw.get('value'))})
        logging.info("Started inserting rows to result table")
        for cur_cluster in ['hahn', 'arnold']:
            ytc = self.yt_connect(cur_cluster)
            logging.info('Inserting rows to table')
            if ytc and self.apc and len(self.apc):
                ytc.insert_rows(self.Parameters.apc_table_path, self.apc, update=True)
                logging.info('Inserted {} rows'.format(len(self.apc)))
            else:
                logging.info('No data to insert')

    def clean_tmp_tables(self):
        self.ytc = self.yt_connect(self.Parameters.cluster)
        self.ytc.remove(self.Parameters.tmp_apc_table_dir + self.Parameters.tmp_apc_table_path + TMP_TABLE_NAME_DST)
        self.ytc.remove(self.Parameters.tmp_apc_table_dir + self.Parameters.tmp_apc_table_path + TMP_TABLE_NAME_SRC)

    def on_execute(self):
        logging.info("Started APC table task!")
        self.resource = sdk2.ResourceData(list(sdk2.Resource.find(id=self.Parameters.resource_id).limit(1))[0])
        self.yql_token = sdk2.task.Vault.data(self.author, self.Parameters.token_vault_name)
        self.ytc = self.yt_connect(self.Parameters.cluster)
        self.run_calculations()
        self.get_data_from_tables()
        self.fill_apc_table()
        self.clean_tmp_tables()
        logging.info("Ended APC table task!")
