#include <util/memory/blob.h>
#include <util/system/filemap.h>


namespace SandboxBlobDump {
    TString RobotsDump(TString path){
        TFileMap mapping(path);
        mapping.Map(0, mapping.Length());
        TBlob blob = TBlob::Copy(mapping.Ptr(), mapping.MappedSize());
        return TString(static_cast<const char*>(blob.Data()), blob.Size());
    }

    TString MirrorsDump(TString path){
        TBlob blob(TBlob::FromFile(path));
        return TString(static_cast<const char*>(blob.Data()), blob.Size());
    }
}
