# coding: utf-8


class YtLogFellerSamplerInterface(object):
    table_format = None
    name = None
    sub_path = None

    @staticmethod
    def rounding_function(ts):
        """Rounding function to construct table name"""
        raise NotImplementedError('Method rounding_function must been redefined')

    @classmethod
    def get_table_name(cls, ts):
        """Return path to table"""
        return cls.rounding_function(ts).strftime(cls.table_format)

    @classmethod
    def get_folder_name(cls, prefix):
        """Return path to folder"""
        return prefix + '/' + cls.sub_path


class YtLogFellerHourSampler(YtLogFellerSamplerInterface):
    table_format = '%Y-%m-%dT%H:%M:%S'
    name = 'Hours'
    sub_path = '1h'

    @staticmethod
    def rounding_function(ts):
        return ts.replace(
            minute=0,
            second=0,
            microsecond=0,
        )


class YtLogFellerDaysSampler(YtLogFellerSamplerInterface):
    table_format = '%Y-%m-%d'
    name = 'Days'
    sub_path = '1d'

    @staticmethod
    def rounding_function(ts):
        return ts.replace(
            hour=0,
            minute=0,
            second=0,
            microsecond=0,
        )


class YtLogFellerSamplers(object):
    Hours = YtLogFellerHourSampler
    Days = YtLogFellerDaysSampler
