import os

import sandbox.sdk2 as sdk2

from sandbox.projects.common import binary_task
from sandbox.projects.rope import RunTaskTemplate
from sandbox.projects.yabs_analytics import resources


class ReleaseParameters(sdk2.Task.Parameters):
    ext_params = binary_task.binary_release_parameters_list(stable=True)


class RunYabsAnalyticsTasks(RunTaskTemplate.RunTaskTemplate, binary_task.LastBinaryTaskRelease):
    class Requirements(sdk2.Requirements):
        """
        Small requirements as most of tasks are simply do yt or yql calls
        """
        disk_space = 2 * 1024  # 2 GiB

        # Requirements for multislot agents
        cores = 1  # < 16
        ram = 512  # 512 MiB < 64 GiB

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    class Parameters(RunTaskTemplate.get_run_params(
        resources.YABS_ANALYTICS_TASK_BINARIES_RESOURCES_RUNNER,
        base_class=RunTaskTemplate.get_run_params(resources.YabsAnalyticsBaseTaskParams,
                                                  base_class=ReleaseParameters)
    )):
        pass

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)
        super(RunYabsAnalyticsTasks, self).on_save()

    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)

        if self.task_params.config_path:
            sdk2.svn.Arcadia.export(
                sdk2.svn.Arcadia.trunk_url(self.task_params.config_path),
                os.path.join(os.getcwd(), os.path.basename(self.task_params.config_path)))

        super(RunYabsAnalyticsTasks, self).on_execute()
