# coding: utf-8

from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.projects.security.common.task import SecurityBaseTask


class PypiIndexer(SecurityBaseTask):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC | ctc.Tag.MULTISLOT
        disk_space = 1024
        ram = 4096
        cores = 8

    class SecurityOptions(SecurityBaseTask.SecurityOptions):
        subtask_resource_attrs = {
            "target": "security/yadi/indexer/cmd/pypi-indexer"
        }

    class Parameters(sdk2.Task.Parameters):
        pypi_login = sdk2.parameters.String("PyPi login (password must be in YADI_INDEXER_PYPI_PASS)", required=True)
        with sdk2.parameters.RadioGroup("Env type") as env_type:
            env_type.values["prod"] = env_type.Value(value="Prod", default=True)
            env_type.values["dev"] = env_type.Value(value="Dev")
        with sdk2.parameters.RadioGroup("Target type") as target_type:
            target_type.values["ext"] = target_type.Value(value="pypi.org", default=True)
            target_type.values["int-local"] = target_type.Value(value="pypi.y-t.ru")
        verbose_mode = sdk2.parameters.Bool("Verbose mode", default=False)
        reindex = sdk2.parameters.Bool("Reindex Them All", default=False)

    def get_cmd(self, binary_path):
        cmd = [
            binary_path,
            "--env-type", self.Parameters.env_type,
            "--target", self.Parameters.target_type,
        ]

        if self.Parameters.verbose_mode:
            cmd.append("--verbose")

        if self.Parameters.reindex:
            cmd.append("--reindex")

        return cmd

    def get_additional_env(self):
        return {
            "YDB_TOKEN": sdk2.Vault.data("YADI_INDEXER_YDB_TOKEN"),
            "PYPI_LOGIN": self.Parameters.pypi_login,
            "PYPI_PASSWORD": sdk2.Vault.data("YADI_INDEXER_PYPI_PASS"),
        }
