# -*- coding: utf-8 -*-
import logging
import time
import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry


logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


def requests_retry_session(
    retries=3,
    backoff_factor=0.3,
    session=None,
):
    session = session or requests.Session()
    retry = Retry(
        total=retries,
        read=retries,
        connect=retries,
        backoff_factor=backoff_factor,
        method_whitelist=False  # retry on any method
    )
    # hack
    retry.RETRY_AFTER_STATUS_CODES = frozenset([413, 429, 503, 502])
    adapter = HTTPAdapter(max_retries=retry)
    session.mount("http://", adapter)
    session.mount("https://", adapter)
    return session


class HecSender(object):
    def __init__(self, token, index=None, source=None, source_type=None):
        self.token = token
        self.index = index
        self.source = source
        self.source_type = source_type
        self.timestamp = str(time.time())
        self.session = None

    def __enter__(self):
        self.session = requests_retry_session()
        self.session.headers.update({"Authorization": "Splunk %s" % self.token})
        return self

    def __exit__(self, exception_type, exception_value, traceback):
        pass

    def send(self, **kwargs):
        data = dict(
            time=self.timestamp,
            index=self.index,
            source=self.source,
            sourcetype=self.source_type,
            event=kwargs
        )

        logger.info("send data to splunk: %r", data)
        resp = self.session.post(
            "https://hatch.yandex.net/services/collector",
            json=dict((k, v) for (k, v) in data.iteritems() if v is not None),
            verify=False
        )
        resp.raise_for_status()
