# coding: utf-8
from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.common.types import task as ctt
from sandbox.common.types.misc import DnsType
from sandbox.projects.security.common.task import SecurityBaseTask


class YadiFeedPush(SecurityBaseTask):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC | ctc.Tag.MULTISLOT
        container_resource = 1598242028
        disk_space = 4096
        ram = 4096
        cores = 8
        dns = DnsType.DNS64

        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='YADI_FEED_PUSH/manifest/prod')
            ]
        )

    class SecurityOptions(SecurityBaseTask.SecurityOptions):
        subtask_resource_attrs = {
            "target": "security/yadi/snatcher/cmd/snatcher"
        }

    class Parameters(sdk2.Task.Parameters):
        verbose = sdk2.parameters.Bool("Verbose mode", default=True)
        force = sdk2.parameters.Bool("Force push", default=False)
        yadi_url = sdk2.parameters.String("Yadi url", default="https://yadi.yandex-team.ru/", required=True)
        storage = sdk2.parameters.String("S3 storage", default="s3.mds.yandex.net", required=True)
        bucket = sdk2.parameters.String("S3 bucket", default="yadi", required=True)

    def get_cmd(self, binary_path):
        cmd = [binary_path]

        if self.Parameters.verbose:
            cmd += ["--verbose"]

        cmd += [
            "push",
            "--url", self.Parameters.yadi_url,
            "--storage", self.Parameters.storage,
            "--bucket", self.Parameters.bucket,
        ]

        if self.Parameters.force:
            cmd += ["--force"]

        return cmd

    def get_additional_env(self):
        return {
            "ACCESS_KEY_ID": sdk2.Vault.data("YADI_S3_ACCESS_KEY_ID"),
            "SECRET_ACCESS_KEY": sdk2.Vault.data("YADI_S3_SECRET_ACCESS_KEY"),
        }
