from sandbox.projects.common.nanny import const as nanny_const
from sandbox.projects.common.nanny import nanny
from sandbox import sdk2
from sandbox.sandboxsdk import svn
from sandbox.common.types.client import Tag
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.yadrive.resources import \
    YaDriveBackend, \
    YaDriveBackendConfigs, \
    YaDriveBackendConfigAdmin, \
    YaDriveBackendConfigChat, \
    YaDriveBackendConfigPrestable, \
    YaDriveBackendConfigProduction, \
    YaDriveBackendConfigQa, \
    YaDriveBackendConfigRobot, \
    YaDriveBackendConfigService, \
    YaDriveBackendConfigTesting, \
    YaDriveBackendConfigLeasing, \
    YaDriveBackendConfigLeasingTesting, \
    YaDriveBackendConfigLeasingPrestable, \
    YaDriveBackendConfigMaas, \
    YaDriveBackendEnvironment, \
    YaDriveDevopsCli, \
    YaDriveTelematics, \
    YaDriveTelematicsConfigs, \
    YaDriveTelematicsConfigStable, \
    YaDriveTelematicsConfigPrestable, \
    YaDriveTelematicsConfigTesting, \
    YaDriveTelematicsConfigWialon, \
    YaDriveRedisProxy, \
    YaDriveOffersConfig, \
    YaDrivePumpkin, \
    YaDrivePumpkinConfigTesting, \
    YaDrivePumpkinConfigStable


class BuildDrive(YaMakeTemplate.YaMakeTemplate):
    class Parameters(YaMakeTemplate.get_project_params([
        YaDriveBackend,
        YaDriveBackendConfigs,
        YaDriveBackendConfigAdmin,
        YaDriveBackendConfigChat,
        YaDriveBackendConfigPrestable,
        YaDriveBackendConfigProduction,
        YaDriveBackendConfigQa,
        YaDriveBackendConfigRobot,
        YaDriveBackendConfigService,
        YaDriveBackendConfigTesting,
        YaDriveBackendConfigLeasing,
        YaDriveBackendConfigLeasingTesting,
        YaDriveBackendConfigLeasingPrestable,
        YaDriveBackendConfigMaas,
        YaDriveBackendEnvironment,
        YaDriveDevopsCli,
        YaDriveTelematics,
        YaDriveTelematicsConfigs,
        YaDriveTelematicsConfigStable,
        YaDriveTelematicsConfigPrestable,
        YaDriveTelematicsConfigTesting,
        YaDriveTelematicsConfigWialon,
        YaDrivePumpkin,
        YaDrivePumpkinConfigTesting,
        YaDrivePumpkinConfigStable,
        YaDriveRedisProxy,
        YaDriveOffersConfig,
    ])):
        pass

    class Requirements(sdk2.Task.Requirements):
        client_tags = Tag.GENERIC & Tag.LINUX_PRECISE
        disk_space = 80000
        ram = 80000

    def get_nanny_release_info(self, additional_parameters):
        result = nanny.ReleaseToNannyTask2.get_nanny_release_info(self, additional_parameters)
        release_tag = additional_parameters.get('release_tag')
        if release_tag:
            result['meta']['labels']['release_tag'] = release_tag
        if release_tag and release_tag != 'unknown' and release_tag != 'none':
            release_type = result['spec']['sandboxRelease']['releaseType']
            result['spec']['sandboxRelease']['releaseType'] = '{}-{}'.format(release_type, release_tag)
        return result

    def on_release(self, additional_parameters):
        if additional_parameters:
            release_subject = additional_parameters.get(nanny_const.RELEASE_SUBJECT_KEY, '')
            if len(release_subject) == 0:
                arcadia_parse_url = svn.Arcadia.parse_url(self.Parameters.checkout_arcadia_from_url)
                additional_parameters[nanny_const.RELEASE_SUBJECT_KEY] = 'trunk/r{}\t{}\t{}'.format(
                    arcadia_parse_url.revision or '<unknown_revision>',
                    self.Parameters.build_type or '<unknown_build_type>',
                    self.Parameters.sanitize or 'non-sanitized',
                )
                configs_only = all((not resource_class.executable for resource_class in self.target_resource_classes))
                if configs_only:
                    additional_parameters[nanny_const.RELEASE_SUBJECT_KEY] = ' '.join(['CONFIGS', additional_parameters[nanny_const.RELEASE_SUBJECT_KEY]])

        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
