# -*- coding: utf-8 -*-

from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.yadrive.resources import \
    YaDriveRedisProxy, \
    YaDriveOffersConfig


class DriveOffersDeploy(ReleaseToYaDeployTask2, YaMake2):
    def get_targets(self):
        return (
            "drive/services/redis_proxy",
        )

    def get_arts(self):
        return [
            {"path": "drive/services/redis_proxy/redis_proxy"},
            {"path": "drive/services/redis_proxy/configs/offers_static_config.yaml"},
        ]

    def get_resources(self):
        return {
            YaDriveRedisProxy.name: {
                "resource_path": "redis_proxy",
                "resource_type": YaDriveRedisProxy,
                "description": YaDriveRedisProxy.name,
            },
            YaDriveOffersConfig.name: {
                "resource_path": "offers_static_config.yaml",
                "resource_type": YaDriveOffersConfig,
                "description": YaDriveOffersConfig.name,
            },
        }
