from sandbox import sdk2

drive_releasers = [
    'afedoseev-kj',
    'arlyapov',
    'blonskii',
    'dbarbashin',
    'eyurkovsk',
    'handozhko',
    'iudovin',
    'kulaad',
    'lehahel',
    'mc-wesban',
    'mr-nikulin',
    'rureggaeton',
    'shemenev-al',
    'svshevtsov',
    'robot-carsharing',
    'yarko09',
]


class YaDriveBackend(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/server/server'


class YaDriveBackendConfigs(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs'


class YaDriveBackendConfigAdmin(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/admin.conf'


class YaDriveBackendConfigChat(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/chat.conf'


class YaDriveBackendConfigPrestable(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/prestable.conf'


class YaDriveBackendConfigProduction(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/production.conf'


class YaDriveBackendConfigQa(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/qa.conf'


class YaDriveBackendConfigRobot(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/robot.conf'


class YaDriveBackendConfigService(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/service.conf'


class YaDriveBackendConfigTesting(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/testing.conf'


class YaDriveBackendConfigLeasing(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/drivematics.conf.xml'


class YaDriveBackendConfigLeasingTesting(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/drivematics_testing.conf.xml'


class YaDriveBackendConfigLeasingPrestable(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/drivematics_prestable.conf.xml'


class YaDriveBackendConfigMaas(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/maas.conf'


class YaDriveBackendEnvironment(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/backend/configs/environment.lua'


class YaDriveDevopsCli(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/devops/cli/cli'


class YaDriveTelematics(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/telematics/server/telematics_server'


class YaDriveTelematicsConfigs(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/telematics/configs'


class YaDriveTelematicsConfigStable(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/telematics/configs/stable.conf'


class YaDriveTelematicsConfigWialon(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/telematics/configs/wialon.conf'


class YaDriveTelematicsConfigPrestable(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/telematics/configs/prestable.conf'


class YaDriveTelematicsConfigTesting(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/telematics/configs/testing.conf'


class YaDriveFunctional(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers


class YaDriveCreateAccounts(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = drive_releasers


class YaDrivePumpkin(sdk2.Resource):
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/pumpkin/server/pumpkin'


class YaDrivePumpkinConfigTesting(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/pumpkin/configs/testing.json'


class YaDrivePumpkinConfigStable(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/pumpkin/configs/stable.json'


class YaDrivePumpkinUsersPermissions(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    releasers = drive_releasers


class YaDrivePumpkinCarsData(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    releasers = drive_releasers


class YaDriveRedisProxy(sdk2.Resource):
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/services/redis_proxy/redis_proxy'


class YaDriveOffersConfig(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    releasers = drive_releasers
    arcadia_build_path = 'drive/services/redis_proxy/configs/offers_static_config.yaml'


class YaDriveCommonExecutable(sdk2.Resource):
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    ttl = "inf"
    releasers = drive_releasers


class YaDriveCommonConfig(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    ttl = "inf"
    releasers = drive_releasers


class YaDriveCommonTestingConfig(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    ttl = "inf"
    releasers = drive_releasers


class YaDriveCommonPrestableConfig(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    ttl = "inf"
    releasers = drive_releasers


class YaDriveCommonProductionConfig(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = True
    ttl = "inf"
    releasers = drive_releasers
