# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts


class YaneBuildTools(YaMakeTask):
    """
        Build all Yane tools.
    """

    type = 'YANE_BUILD_TOOLS'

    input_parameters = build_params.get_common_build_params(default=consts.YMAKE_BUILD_SYSTEM)
    client_tags = ~ctc.Tag.Group.LINUX | ctc.Tag.LINUX_PRECISE
    cores = 24

    targets = [
        'yt/python/yt/wrapper/bin/mapreduce-yt_make',
        'dict/ext/pairfreq/findpairs3',
        'dict/gazetteer/compiler',
        'dict/ontodb/cardsparser',
        'dict/tools/corpusparser',
        'dict/tools/ner/antiobj',
        'dict/tools/ner/features',
        'dict/tools/ner/mr_dump',
        'dict/tools/ner/objectsextractor',
        'dict/tools/ner/pooltools',
        'dict/tools/ner/markupdaemon',
        'quality/mapreduce',
        'quality/mr_apps/mr_rm'
    ]

    out_binaries = [
        'yt/python/yt/wrapper/bin/mapreduce-yt_make/mapreduce-yt',
        'dict/ext/pairfreq/findpairs3/findpairs3',
        'dict/gazetteer/compiler/gztcompiler',
        'dict/ontodb/cardsparser/bin/cardsparser',
        'dict/tools/corpusparser/corpusparser',
        'dict/tools/ner/antiobj/antiobj',
        'dict/tools/ner/features/corpusfeatures/corpusfeatures',
        'dict/tools/ner/features/freebasefeatures/freebasefeatures',
        'dict/tools/ner/features/idstriecreator/idstriecreator',
        'dict/tools/ner/features/ontodb_ver/ontodb_ver',
        'dict/tools/ner/features/protostoragecreator/protostoragecreator',
        'dict/tools/ner/features/querylogfeatures/querylogfeatures',
        'dict/tools/ner/features/relurlsextractor/relurlsextractor',
        'dict/tools/ner/features/relwordsextractor/relwordsextractor',
        'dict/tools/ner/features/spylogsparser/spylogsparser',
        'dict/tools/ner/features/votingcontexts/top_n/top_n',
        'dict/tools/ner/features/wikilinksfeatures/wikilinksfeatures',
        'dict/tools/ner/mr_dump/mr_dump',
        'dict/tools/ner/objectsextractor/objectsextractor',
        'dict/tools/ner/pooltools/pooltools',
        'dict/tools/ner/markupdaemon/markupdaemon',
        'quality/mapreduce/with_nalf/mapreduce',
        'quality/mr_apps/mr_rm/mr_rm'
    ]

    # 40G is not enough
    execution_space = 100 * 1024

    # Build python binding with system python
    # TODO: fix error with system python
    # def pre_build(self, source_dir):
    #    self.ctx['use_system_python'] = True

    def get_targets(self):
        return self.targets

    def get_build_def_flags(self):
        return '-DCFLAGS="-DENABLE_DEBUG_TIMERS"'

    def get_arts(self):
        return [{'path': x} for x in self.out_binaries]

    def get_resources(self):
        resource_name = 'tools' if not self.ctx.get('do_apply_patch', False) else 'tools_patched'

        return {
            resource_name: {
                'description': self.descr,
                'resource_type': resource_types.YANE_TOOLS,
            }
        }


__Task__ = YaneBuildTools
