import requests


class YappyApi(object):
    LINEAGE_URL = 'http://yappy.z.yandex-team.ru/api/yappy.services.Lineage2'
    MODEL_URL = 'http://yappy.z.yandex-team.ru/api/yappy.services.Model'

    def __init__(self, oauth_token=None):
        self.headers = {'Content-type': 'application/json'}
        if oauth_token:
            self.headers['Authorization'] = 'OAuth ' + oauth_token

    def _post(self, url, payload):
        response = requests.post(url, json=payload, headers=self.headers, timeout=10)
        if not response.ok:
            raise ValueError('request {} failed:\n{}\n{}\n{}'.format(url, response.content, response.headers, response.status_code))
        return response

    def create_beta_from_template(self, payload):
        r = self._post('{}/createBetaFromBetaTemplate'.format(self.LINEAGE_URL), payload=payload)

        if r.json().get('status') != 'SUCCESS':
            raise RuntimeError('create beta from template failed:\n{}'.format(r.json()))

        return r.json()

    def beta_exists(self, payload):
        return self._post('{}/betaExists'.format(self.MODEL_URL), payload=payload).json()

    def delete_beta(self, payload):
        return self._post('{}/deleteBeta'.format(self.LINEAGE_URL), payload=payload).json()

    def deallocate_beta(self, payload):
        return self._post('{}/deallocateBeta'.format(self.LINEAGE_URL), payload=payload).json()

    def get_beta_status(self, payload):
        return self._post('{}/getBetaStatus'.format(self.MODEL_URL), payload=payload).json()
