from sandbox.projects.yappy.configs import main_configs


GoodsReportConfig = main_configs.BetaTemplateConfig(
    template_name='goods-report',
    components=[
        main_configs.BetaTemplateComponentConfig(
            id='goods-report',
            patch=main_configs.PatchConfig(
                parent_external_id='goods_report_beta_template',
                copy_coredump_policy=True,
                resources=[
                    main_configs.ResourceConfig(
                        local_path='report',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='report_data',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='formulas',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='dynamic_models',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='configs',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='flags',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='evlogdump',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='tvmtool',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='push-client',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='access-agent.tar.gz',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='mini-tank',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='seder.sh',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='ammo',
                        storage='/ssd',
                    ),
                    main_configs.ResourceConfig(
                        local_path='shard',
                        manage_type='SANDBOX_SHARDMAP',
                        storage='/ssd',
                    ),
                ]
            )
        )
    ]
)
