from sandbox.projects.yappy.configs import main_configs


BASE_PATCH = main_configs.PatchConfig(
    parent_external_id='sas-imgs-cbir-goods',
    resources=[
        main_configs.ResourceConfig(
            local_path='shard',
            manage_type='SANDBOX_SHARDMAP',
        ),
    ],
)

MMETA_PATCH = main_configs.PatchConfig(
    parent_external_id='production_imgmmeta_sas',
    ignore_instance_spec=True,
    resources=[
        main_configs.ResourceConfig(
            local_path='httpsearch',
            manage_type='SANDBOX_RESOURCE',
        ),
        main_configs.ResourceConfig(
            local_path='iss_shards',
            manage_type='SANDBOX_RESOURCE',
        ),
        main_configs.ResourceConfig(
            local_path='loop.conf',
            manage_type='DELETE',
        ),
    ],
)

ImgsCbirGoodsBeta1Config = main_configs.BetaTemplateConfig(
    template_name='imgs-cbir-goods-beta1',
    components=[
        main_configs.BetaTemplateComponentConfig(
            id='imgs-cbir-goods-beta1',
            patch=BASE_PATCH,
        ),
        main_configs.BetaTemplateComponentConfig(
            id='imgs-cbir-goods-beta1-mmeta',
            patch=MMETA_PATCH,
        ),
    ],
)

ImgsCbirGoodsBeta2Config = main_configs.BetaTemplateConfig(
    template_name='imgs-cbir-goods-beta2',
    components=[
        main_configs.BetaTemplateComponentConfig(
            id='imgs-cbir-goods-beta2',
            patch=BASE_PATCH,
        ),
        main_configs.BetaTemplateComponentConfig(
            id='imgs-cbir-goods-beta2-mmeta',
            patch=MMETA_PATCH,
        ),
    ],
)
