# -*- coding: utf-8 -*-


class BetaTemplateConfig(object):
    def __init__(self, template_name='', components=None):
        self.template_name = template_name
        self.components = components or []


class BetaTemplateComponentConfig(object):
    def __init__(self, id='', patch=None):
        self.id = id
        self.patch = patch or PatchConfig()


class PatchConfig(object):
    def __init__(self, parent_external_id='', ignore_instance_spec=False, resources=None, copy_coredump_policy=False):
        self.parent_external_id = parent_external_id
        self.ignore_instance_spec = ignore_instance_spec
        self.resources = resources or []
        self.copy_coredump_policy = copy_coredump_policy


class ResourceConfig(object):
    def __init__(self, local_path='', alias='', sandbox_resource_id='', manage_type='SANDBOX_RESOURCE', storage=''):
        self.local_path = local_path
        self.alias = alias
        self.sandbox_resource_id = sandbox_resource_id
        self.manage_type = manage_type
        self.storage = storage


class StaticContentConfig(object):
    def __init__(self, local_path='', alias='', content=''):
        self.local_path = local_path
        self.alias = alias
        self.content = content
