# coding: utf-8

from sandbox import sdk2

from sandbox.projects.resource_types import search_priemka_releasers

yappy_releasers = [
    'lebedev-aa',
    'pufit',
    'rebenkoy',
    'robot-testenv',
    'robot-yappy',
    'mgolosova',
]


class YappyBinary(sdk2.Resource):
    """
        Yappy binary.
    """
    any_arch = False
    arcadia_build_path = 'search/priemka/yappy/bin/yappy'
    auto_backup = True
    releasable = True
    releasers = yappy_releasers


class YappyArcadiaCache(sdk2.Resource):
    releasable = False
    any_arch = True
    auto_backup = True


class YappyResource(sdk2.Resource):
    """
    Abstract Yappy resource.
    """
    releasable = True
    any_arch = False
    releasers = search_priemka_releasers
    auto_backup = True


class YappyCrawlerBinary(YappyResource):
    """
    Yappy crawler binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/yappy_crawler'


class YappyImporterBinary(YappyResource):
    """
    Yappy importer binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/bin/yappy_importer'


class YappyModelBinary(YappyResource):
    """
    Yappy model binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/bin/yappy_model'


class YappyProxyBinary(YappyResource):
    """
    Yappy proxy binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/yappy_proxy'


class YappyTranslatorBinary(YappyResource):
    """
    Yappy translator binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/yappy_translator'


class YappyVerificatorBinary(YappyResource):
    """
    Yappy verificator binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/yappy_verificator'


class YappyBalancerAgentBinary(YappyResource):
    """
    Yappy balancer agent binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/yappy_balancer_agent'


class YappyIntegrationTestsBinary(YappyResource):
    """
    Yappy integration tests binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/integration_tests/'


class YappyLogwatcherBinary(YappyResource):
    """
    Yappy logwatcher binary.
    """
    arcadia_build_path = 'search/priemka/yappy/src/yappy_logwatcher/'


class YappyUIBundle(YappyResource):
    """
    Transpiled, minimized and archived files for YAPPY UI.
    """
