# coding: utf-8

import os

import sandbox.common.types.client as ctc

import sandbox.common.types.misc as ctm
from sandbox.projects.yasm.resource_types import YASMCORE
from sandbox.projects.yasm.common.BaseBuildCoreYasmTask import BaseBuildCoreYasmTask
from sandbox.projects.common.nanny import nanny


class BuildYasmCore(BaseBuildCoreYasmTask):
    type = 'BUILD_YASM_CORE'
    dns = ctm.DnsType.DNS64
    client_tags = ctc.Tag.LINUX_PRECISE

    SERVICE_NAME = 'yasmcore'
    TGZ_PATH = '{}.tar.gz'.format(SERVICE_NAME)
    RESOURCE_TYPE = YASMCORE
    COPY_DIRS = {
        'yasmserver5': 'yasmserver5',
        'yasmdumper': 'yasmdumper',
        'yasmhserver': 'yasmhserver',
        'yasmalertserver': 'yasmalertserver',
        'yasmcollector': 'yasmcollector',
        'ambry': 'ambry',
        'yasmutil': os.path.join('yasmagent', 'lib', 'yasmutil'),
        'rtfront': 'rtfront',
        'histfront': 'histfront',
        'scripts': 'scripts',
        'front.conf': 'front.conf',
        'server.conf': 'server.conf',
        'agent.conf': 'agent.conf',
        'collector.conf': 'collector.conf',
        'CONF': os.path.join('yasmagent', 'CONF'),
        'groups_cached': 'groups_cached',
        'biller': 'biller',
        'biller.conf': 'biller.conf'
    }
    REMOVE_DIRS = [
        BaseBuildCoreYasmTask.CHECKOUT_PATH, os.path.join(BaseBuildCoreYasmTask.BUILD_DIR, 'yasmcore', 'debian')
    ]

    def initCtx(self):
        ctx = BaseBuildCoreYasmTask.initCtx(self)
        ctx.update(kill_timeout=20 * 60)
        return ctx

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildYasmCore
