# Common library for Golovan Push API

import contextlib
import json
import logging
import urllib2

from sandbox import common


_INSTANCE_TYPE_TAG = "sandboxtask"
_CLUSTER_TYPE_TAG = "prod"
_YASMAGENT_TIMEOUT = 5


class PushError(Exception):
    def __init__(self, status, *args, **kwargs):
        Exception.__init__(self, *args, **kwargs)
        self.status = status


def push_signal(name, prj, value, itype=None, ttl=None):
    """Sends signal to local agent"""

    query = [{
        "name": name,
        "val": value,
        "tags": {"itype": itype or _INSTANCE_TYPE_TAG, "ctype": _CLUSTER_TYPE_TAG, "prj": prj},
    }]
    if ttl is not None:
        query[0]["ttl"] = ttl

    try:
        url = "http://{}:11005".format(common.config.Registry().this.fqdn)
        logging.info("Sending signal to {} with value={}".format(url, value))
        with contextlib.closing(urllib2.urlopen(url, json.dumps(query), _YASMAGENT_TIMEOUT)) as f:
            response = _read_json(f)
            status = response.get("status")
            if status != "ok":
                raise PushError(status, "Bad response status: {}: {}".format(status, response))
    except urllib2.HTTPError as e:
        raise PushError("httperror", "Failed to send signal: {}: {}".format(e, _read_json(e)))
    except urllib2.URLError as e:
        raise PushError("urlerror", "Failed to send signal: {}".format(e))


def _read_json(f):
    """Helper method to read answer and parse json"""

    try:
        content = f.read()
        return json.loads(content)
    except Exception as e:
        raise PushError("Failed to parse response: {}: {}".format(content, e))
