# coding: utf-8
from __future__ import absolute_import

from sandbox import sdk2

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class YASMCORE(AbstractResource):
    """
        Yasmcore project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMAGENT_SKYCORE(AbstractResource):
    """
        Yasmagent for Skycore
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMAGENT_DEB(AbstractResource):
    """
        Yasmagent deb package
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMAGENT_VENV(AbstractResource):
    """
        Yasmagent venv package
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']


class YASMAGENT_BALANCER_REPORT_MODULE(AbstractResource):
    """
        module for balancer report
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM', 'BALANCER']
    release_subscribers = ['golovan-dev']


class YASM_TESTIT(AbstractResource):
    """
        service for unstable yasm agents check
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASM_DOCKER(AbstractResource):
    """
        Yasm sources for docker building
    """
    releasable = True


class YASM_DOCS(AbstractResource):
    """
        YASM DOCS
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']


class CLICKHOUSE_YASM_BINARY(AbstractResource):
    """
        Clickhouse for yasm
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_NEH_MODULE(AbstractResource):
    """
        module for neh bindings
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_COLLECTOR_MODULE(AbstractResource):
    """
        module for collector
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_FAST_CONFIG_MODULE(AbstractResource):
    """
        module for fast config
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_DATADUMPER_MODULE(AbstractResource):
    """
        module for data dumper
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_HISTDB_MODULE(AbstractResource):
    """
        module for histdb
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_CPPZOOM_MODULE(AbstractResource):
    """
        module for cpp zoom bindings
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_CPPPLAYER_MODULE(AbstractResource):
    """
        module for cpp player bindings
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_TSDB_BINARY(AbstractResource):
    """
        tsdb binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_HISTDB_CACHER_BINARY(AbstractResource):
    """
        histdb cacher binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_HISTDB_DUMPER_BINARY(AbstractResource):
    """
        histdb dumper binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_SUBSCRIPTIONS_BINARY(AbstractResource):
    """
        subscriptions binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_STOCKPILE_PROXY_BINARY(AbstractResource):
    """
        stockpile proxy binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_COLLECTOR_BINARY(AbstractResource):
    """
        collector binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']


class YASMCORE_SNAPSHOOTER_BINARY(AbstractResource):
    """
        snapshooter binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YASM']
    release_subscribers = ['golovan-dev']
