import os
import shutil

from sandbox import sdk2

from sandbox.common.types.client import Tag
from sandbox.projects.common.yappy.base_build_patched import BuildPatched
from sandbox.projects.ydl.resource_types import YDLProxyBinary, YDLReaderBinary, YDLWriterBinary, YDLWorkerBinary


class BuildPatchedYDL(BuildPatched):
    class Requirements(BuildPatched.Requirements):
        client_tags = Tag.GENERIC | Tag.CUSTOM_WIZARD

    @property
    def github_context(self):
        return '[Sandbox] Build and test'

    @property
    def project_conf(self):
        return {
            'github': {
                'report_statuses': self.Parameters.report_github_statuses
            }
        }

    @property
    def arcadia_project_path(self):
        return 'search/ydl'

    @property
    def bundle_info(self):
        return {
            'startup/proxy/ydl_proxy': YDLProxyBinary,
            'startup/reader/ydl_reader': YDLReaderBinary,
            'startup/writer/ydl_writer': YDLWriterBinary,
            'startup/worker/ydl_worker': YDLWorkerBinary,
        }

    def install(self):
        pass

    def after_build(self):
        with self.info_section('<bundle>'):
            dist_path = str(self.path('dist'))
            os.mkdir(dist_path)

            for path, resource_type in self.bundle_info.items():
                symlink_path = str(os.path.join(self.Context.project_root, path))
                bin_path = os.readlink(symlink_path)
                filename = os.path.basename(bin_path)
                copy_path = os.path.join(dist_path, filename)
                shutil.copy2(bin_path, copy_path)
                sdk2.ResourceData(resource_type(self, description=str(resource_type), path=copy_path)).ready()
