# coding: utf-8

from sandbox import sdk2


class YDLResource(sdk2.Resource):
    """
    Abstract YDL resource.
    """
    any_arch = False
    auto_backup = True
    releasable = True

    releasers = [
        'pmankevich',
        'lebedev-aa',
    ]


class YDLProxyBinary(YDLResource):
    """
    YDL proxy binary.
    """
    arcadia_build_path = 'search/ydl/startup/proxy'


class YDLReaderBinary(YDLResource):
    """
    YDL reader binary.
    """
    arcadia_build_path = 'search/ydl/startup/reader'


class YDLWriterBinary(YDLResource):
    """
    YDL writer binary.
    """
    arcadia_build_path = 'search/ydl/startup/writer'


class YDLWorkerBinary(YDLResource):
    """
    YDL worker binary.
    """
    arcadia_build_path = 'search/ydl/startup/worker'


class YDLUIBundle(YDLResource):
    """
    Transpiled, minimized and archived files for YDL UI.
    """
