import calendar
import datetime
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp, ProcessLog

from sandbox.common.errors import TaskFailure, TaskError

from sandbox.projects.sandbox.resources import LXC_CONTAINER

from sandbox.projects.ydo.resource_types import ydo_releasers, content_releasers  # noqa

def get_date(relative_flag, days_delta, date_str):
    if relative_flag:
        return datetime.date.today() + datetime.timedelta(days_delta)
    else:
        return datetime.datetime.strptime(date_str, '%Y-%m-%d').date()

def get_now_utc():
    return calendar.timegm(datetime.datetime.utcnow().utctimetuple())


def get_id_or_none(object):
    return getattr(object, "id", None)


def get_last_released_resource(ResourceClass, condition=True, default=None, error_msg="Resource not founded"):
    if condition:
        resource = ResourceClass.find(attrs=dict(released="stable")).first()
    else:
        resource = default

    assert resource is not None, error_msg

    return sdk2.ResourceData(resource)

def wait_process(process, error_message, fail_on_error=True):
    process_result = process.wait()
    if process_result != 0:
        if fail_on_error:
            raise TaskFailure(error_message)
        else:
            raise TaskError(error_message)

def execute_cmd(cmd, log_name, error_message='', stdin=None, stdout=None, fail_on_error=True, env=os.environ.copy(), should_wait=True, **kwargs):
    with ProcessLog(logger=log_name) as pl:
        process = sp.Popen(cmd, stdin=stdin, stdout=stdout or pl.stdout, stderr=pl.stderr, env=env, **kwargs)
        if should_wait:
            wait_process(process, error_message, fail_on_error)
        else:
            return process


class YdoLxcContainer(LXC_CONTAINER):
    releasers = ydo_releasers


class YdoKikimrExecutable(sdk2.Resource):
    releasers = ydo_releasers
    executable = True
    releasable = True


class YdoDatabaseConfig(sdk2.Resource):
    releasers = ydo_releasers
    releasable = True


class YdoDatabaseTestConfig(sdk2.Resource):
    releasers = ydo_releasers
    releasable = True


class YdoDbManagementExecutable(sdk2.Resource):
    releasers = ydo_releasers
    executable = True
    releasable = True


class YdoYdbExecutable(sdk2.Resource):
    releasers = ydo_releasers
    executable = True
    releasable = True


class YdoContactRemindersExecutable(sdk2.Resource):
    releasers = ydo_releasers
    executable = True
    releasable = True


class YdoFeaturesJson(sdk2.Resource):
    """
        Json with features
    """
    releasable = True
    releasers = ydo_releasers


class YdoSeoNamesJson(sdk2.Resource):
    """
        Json with seo names
    """
    releasable = True
    releasers = ydo_releasers


class YdoWizardsJson(sdk2.Resource):
    """
        Json with scenarios for clarifier
    """
    releasable = True
    releasers = ydo_releasers


class YdoWizardsExperimentalJson(sdk2.Resource):
    """
        Json with scenarios for clarifier (for experiments only)
    """
    releasable = True
    releasers = ydo_releasers


class YdoCollectionsJson(sdk2.Resource):
    """
        Json with collections
    """
    releasable = True
    releasers = ydo_releasers


class YdoBannedOrderCustomers(sdk2.Resource):
    """
        Blacklist of puids
    """
    releasable = True
    releasers = ydo_releasers


class YdoUnBannedOrderCustomers(sdk2.Resource):
    """
        Whitelist of puids
    """
    releasable = True
    releasers = ydo_releasers


class YdoServicesPriceIntervalsJson(sdk2.Resource):
    """
        Json with services price intervals
    """
    releasable = True
    releasers = ydo_releasers


class YdoPartnerTelephoneCardSettingsJson(sdk2.Resource):
    """
        Json with partner telephone card settings
    """
    releasable = True
    releasers = ydo_releasers


class YdoCallCenterCardSettingsJson(sdk2.Resource):
    """
        Json with call center card settings
    """
    releasable = True
    releasers = ydo_releasers


class YdoRubricsDump(sdk2.Resource):
    """
        Json with rubrics
    """
    releasable = True
    releasers = ydo_releasers


class YdoDocDocRubricsDump(sdk2.Resource):
    """
        Json with docdoc rubrics
    """
    releasable = True
    releasers = ydo_releasers


class YdoSpravRubricsDump(sdk2.Resource):
    """
        Json with sprav rubrics
    """
    releasable = True
    releasers = ydo_releasers


class YdoGeo2WorkersCountDump(sdk2.Resource):
    """
        Json with geoid to workers number
    """
    releasable = True
    releasers = ydo_releasers


class YdoDocDocGeo2WorkersCountDump(sdk2.Resource):
    """
        Json with docdoc geoid to workers number
    """
    releasable = True
    releasers = ydo_releasers


class YdoSpravGeo2WorkersCountDump(sdk2.Resource):
    """
        Json with sprav geoid to workers number
    """
    releasable = True
    releasers = ydo_releasers


class YdoWorkersGroups(sdk2.Resource):
    """
        Ysonl with rubrics
    """
    releasable = True
    releasers = ydo_releasers


class YdoCustomizerJson(sdk2.Resource):
    """
        Json with custom texts for buttons on profile and serp
    """
    releasable = True
    releasers = ydo_releasers


class YdoOrderCustomizerJson(sdk2.Resource):
    """
        Json with custom forms for orders
    """
    releasable = True
    releasers = content_releasers


class YdoTestingOrderCustomizerJson(sdk2.Resource):
    """
        Json with custom forms for orders (testing)
    """
    releasable = True
    releasers = content_releasers


class YdoRawOrderCustomizerJson(sdk2.Resource):
    """
        Json with custom forms for orders (raw/base)
    """
    releasable = True
    releasers = content_releasers


class YdoWizardCustomizerJson(sdk2.Resource):
    """
        Json with custom parameters for wizard and service
    """
    releasable = True
    releasers = ydo_releasers


class YdoGoodReviewsWithPublicIds(sdk2.Resource):
    """
        TSV file with {worker_id,public_id} to filter reviews in experiment BLITZKRIEG-300
    """
    releasable = True
    releasers = ydo_releasers


class YdoOrderCustomFields(sdk2.Resource):
    """
        Json description for available custom fields for orders (/arcadia/ydo/rubricator/order_custom_fields.json)
    """
    releasable = True
    releasers = ydo_releasers


class YdoMainSitemap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSpravSitemap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoDocDocSitemap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSmModelSitemap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoUnpublishedSitemap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSeoCommonBlockCustomizer(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSeoWorkerBlockCustomizer(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSeoServicesBlockCustomizer(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSeoBrandsBlockCustomizer(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSeoRequestsBlockCustomizer(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoRubricsSeoNames(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoRubricatorVersion(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoHyperlinksJson(sdk2.Resource):
    """
        List of jsons with hyperlinks data for popular rubrics (YDO-21259)
    """
    releasable = True
    releasers = ydo_releasers


class YdoMarketOrderClarifierGraphVersionsJson(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers
