from sandbox import sdk2

from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.ydo import execute_cmd, ydo_releasers, YdoFeaturesJson
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.ydo.rubrics_merger.YdoRubricsMerger import YdoMergedRubricsSmallDump


class YdoAggregatePartnerPricesExecutable(sdk2.Resource):
    """
    Aggregate prices from partners' price lists
    """

    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoAggregatePartnerPrices(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            ydo_aggregate_partner_prices=YdoAggregatePartnerPricesExecutable,
            geobase_snapshot=ResourceWrapper(GEODATA6BIN_STABLE),
            rubrics_json=YdoMergedRubricsSmallDump,
            features_json=YdoFeaturesJson,
            check_owner=True,
            with_environ=True,
        )
    ):
        backup_path = sdk2.parameters.String('Path to directory with backups', required=True)
        output_path = sdk2.parameters.String('Path to table with results', required=True)
        output_to_ydb = sdk2.parameters.Bool('Also update ydb table with prices', default=False)
        yt_proxy = sdk2.parameters.String('YT proxy', default='hahn')
        self_tvm_id = sdk2.parameters.String('Self tvm_id', required=True)
        internal_erp_url = sdk2.parameters.String('URL (with path prefix) for internal erp requests', required=True)
        internal_erp_tvm_id = sdk2.parameters.String('Internal erp tvm_id', required=True)

        ydb_host = sdk2.parameters.String('YDB host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB port', default=2135)
        ydb_database = sdk2.parameters.String('YDB database', required=True)
        ydb_home = sdk2.parameters.String('YDB home', required=True)

        force_delete = sdk2.parameters.Bool('Force delete old rows from ydb table', default=False)
        use_price_list_tags = sdk2.parameters.Bool('Use split by price list tags from erp', default=False)

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_aggregate_partner_prices_path,
            '--backup_path',
            self.Parameters.backup_path,
            '--output_path',
            self.Parameters.output_path,
            '--yt_proxy',
            self.Parameters.yt_proxy,
            '--self_tvm_id',
            self.Parameters.self_tvm_id,
            '--internal_erp_url',
            self.Parameters.internal_erp_url,
            '--internal_erp_tvm_id',
            self.Parameters.internal_erp_tvm_id,
            '--geobase_file',
            self.Parameters.geobase_snapshot_path,
            '--rubrics_json',
            self.Parameters.rubrics_json_path,
            '--features_json',
            self.Parameters.features_json_path,
        ]
        
        if self.Parameters.output_to_ydb:
            cmd += [
                '--output_to_ydb',
                '--ydb_host',
                self.Parameters.ydb_host,
                '--ydb_port',
                str(self.Parameters.ydb_port),
                '--ydb_database',
                self.Parameters.ydb_database,
                '--ydb_home',
                self.Parameters.ydb_home,
            ]

        if self.Parameters.force_delete:
            cmd.append('--force_delete')

        if self.Parameters.use_price_list_tags:
            cmd.append('--use_price_list_tags')

        execute_cmd(
            cmd, 'aggregate_partner_prices', 'aggregate_partner_prices failed', env=self.Parameters.get_environ()
        )
