from sandbox import sdk2
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo import resource_types
from sandbox.projects.ydo import build


class YdoAnalyzeSpwExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = resource_types.ydo_releasers
    arcadia_build_path = 'ydo/devops/monitorings/analyze_scripts/analyze_spw'
    executable = True

    binary_path = sdk2.parameters.String(default='analyze_spw')


class BuildYdoAnalyzeSpwExecutable(build.YdoYaMakeTemplate):
    class Parameters(build.get_project_params([YdoAnalyzeSpwExecutable])):
        pass


class YdoAnalyzeSpw(sdk2.Task):
    class Parameters(generate_view(
        analyze_spw=YdoAnalyzeSpwExecutable, check_owner=True, with_environ=True,
        default_secret_env_vars={
            'YT_TOKEN': 'yt-token',
            'ST_TOKEN': 'ydo_robot_services_st_token'
        }
    )):
        pass

    def on_execute(self):
        execute_cmd([self.Parameters.analyze_spw_path], 'analyze_spw', 'analyze_spw failed',
                    env=self.Parameters.get_environ())
