# coding: utf-8
import logging

import sandbox.sdk2 as sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.common import task_env
from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)


class YdoArbitrageCreatorExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoArbitrageCreator(sdk2.Task):
    """
        Создание арбитражей
    """

    class Requirements(task_env.TinyRequirements):
        ram = 1024
        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

    class Parameters(generate_view(ydo_arbitrage_creator=YdoArbitrageCreatorExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):

            orders_table = sdk2.parameters.String('Path to orders backup', required=True)
            orders_aux_table = sdk2.parameters.String('Path to orders aux backup', required=True)
            order_events_history_table = sdk2.parameters.String('Path to order events history backup', required=True)
            orders_fraud_price_arbitrage_table = sdk2.parameters.String('Path to orders fraud price arbitrage backup', required=True)

        samsara_api_host = sdk2.parameters.String('Samsara api host', required=True)
        samsara_queue_id = sdk2.parameters.String('Samsara queue id', required=True)
        oauth_token_name = sdk2.parameters.String('OAuth token', required=True)
        adminka_home_url = sdk2.parameters.String('Adminka home url', required=True)
        backend_home_url = sdk2.parameters.String('Backend home url', required=True)

        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_arbitrage_creator_path,
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),

            '--orders', self.Parameters.orders_table,
            '--orders_aux', self.Parameters.orders_aux_table,
            '--order_events_history', self.Parameters.order_events_history_table,
            '--orders_fraud_price_arbitrage', self.Parameters.orders_fraud_price_arbitrage_table,


            '--samsara_api_host', self.Parameters.samsara_api_host,
            '--samsara_queue_id', self.Parameters.samsara_queue_id,
            '--oauth_token_name', self.Parameters.oauth_token_name,
            '--adminka_home_url', self.Parameters.adminka_home_url,
            '--backend_home_url', self.Parameters.backend_home_url,
        ]

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))
        execute_cmd(cmd, 'ydo_arbitrage_creator', 'ydo_arbitrage_creator failed', env=self.Parameters.get_environ())
