import sandbox.projects.ydo.process_generator as process_generator


def generate_process_generator(mode):
    class TaskMixin(process_generator.BaseMixin):
        def get_cmd(self):
            return [self.get_binary_path(), mode, 'config', self.get_config_path()]

    class ProcessGenerator(process_generator.ProcessGenerator):
        TaskMixinClass = TaskMixin

    return ProcessGenerator


pg_analyze_access_log = generate_process_generator('analyze_access_log')(
    'ydo/tools/avatars_cleaner/bin',
    binary_name='avatars_cleaner',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/avatars_cleaner/bin/configs/analyze_access_log',
        [
            ('production', 'production_config.yaml'),
            ('testing', 'testing_config.yaml'),
        ],
    ),
    use_yav_secrets=False,
)


class YdoAvatarsCleanerExecutable(pg_analyze_access_log.generate_resource()):
    pass


class BuildYdoAvatarsCleanerExecutable(pg_analyze_access_log.generate_build_task(YdoAvatarsCleanerExecutable)):
    pass


class YdoAvatarsCleanerAnalyzeAccessLog(pg_analyze_access_log.generata_task(YdoAvatarsCleanerExecutable)):
    pass


pg_analyze_db = generate_process_generator('analyze_db')(
    'ydo/tools/avatars_cleaner/bin',
    binary_name='avatars_cleaner',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/avatars_cleaner/bin/configs/analyze_db',
        [
            ('production', 'production_config.yaml'),
            ('testing', 'testing_config.yaml'),
        ],
        auto_post_process=True,
    ),
    use_yav_secrets=False,
)


class YdoAvatarsCleanerAnalyzeDB(pg_analyze_db.generata_task(YdoAvatarsCleanerExecutable)):
    pass


pg_delete_healthy_photos = generate_process_generator('delete_healthy_photos')(
    'ydo/tools/avatars_cleaner/bin',
    binary_name='avatars_cleaner',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/avatars_cleaner/bin/configs/delete_healthy_photos',
        [
            ('production', 'production_config.yaml'),
            ('testing', 'testing_config.yaml'),
        ],
    ),
    use_yav_secrets=False,
)


class YdoAvatarsCleanerDeleteHealthyPhotos(pg_delete_healthy_photos.generata_task(YdoAvatarsCleanerExecutable)):
    pass
