# coding: utf-8

from __future__ import absolute_import

from sandbox import sdk2

from sandbox.projects.ydo.resource_types import ydo_releasers


class YdoSaasSearchProxy(sdk2.Resource):
    """
        Resource YDO_SAAS_SEARCH_PROXY binary
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSaasSearchProxyLoopConf(sdk2.Resource):
    """
        Resource YDO_SAAS_SEARCH_PROXY_LOOP_CONF
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSaasSearchProxyLoopData(sdk2.Resource):
    """
        Resource YDO_SAAS_SEARCH_PROXY_LOOP_DATA
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSaasSearchProxyModels(sdk2.Resource):
    """
        Resource YDO_SAAS_SEARCH_PROXY_MODELS
        Ranking and blender ranking factors models
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSaasSearchProxyWord2Vec(sdk2.Resource):
    """
        Resource YDO_SAAS_SEARCH_PROXY_WORD2_VEC
        Word2Vec
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSaasSearchProxyDssm(sdk2.Resource):
    """
        Resource YDO_SAAS_SEARCH_PROXY_DSSM
        DSSM
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoRubricEmbeddings(sdk2.Resource):
    """
        Resource YDO_RUBRIC_EMBEDDINGS
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoRubricatorFeatures(sdk2.Resource):
    """
        Resource YDO_RUBRICATOR_FEATURES saas searchproxy file for proxy
    """
    releasable = True
    releasers = ydo_releasers


class YdoProblemsList(sdk2.Resource):
    """
        Resource YDO_PROBLEMS_LIST saas searchproxy file for proxy
    """
    releasable = True
    releasers = ydo_releasers


class YdoClinicsList(sdk2.Resource):
    """
        Resource YDO_CLINICS_LIST saas searchproxy file or proxy
    """
    releasable = True
    releasers = ydo_releasers


class YdoSearchProxyConfig(sdk2.Resource):
    """
        Resource YDO_SEARCH_PROXY_CONFIG
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoWorkersPuidList(sdk2.Resource):
    """
        Resource YDO_WORKERS_PUID_LIST for ydo metasearch
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSearchProxyConfigBundle(sdk2.Resource):
    """
        Resource YDO_SEARCH_PROXY_CONFIG_BUNDLE
        autogenerated config templates for ydo metasearch
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSearchProxyRearrangeData(sdk2.Resource):
    """
        Resource YDO_SEARCH_PROXY_REARRANGE_DATA
        Data shard for ydo metasearch
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSearchProxyRearrangeDataTest(sdk2.Resource):
    """
        Resource YDO_SEARCH_PROXY_REARRANGE_DATA_TEST
        Data shard for ydo metasearch
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
