from sandbox import sdk2

from sandbox.projects.ydo.backup import YdoBackupBaseTask


class YdoBackupLinkTables(YdoBackupBaseTask):
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("YT parameters") as yt_block:
            yt_vault_token = sdk2.parameters.String("Your yt token name in vault", default="yt-token", required=True)
            with sdk2.parameters.RadioGroup("Host") as yt_host:
                yt_host.values["hahn"] = yt_host.Value(value="Hahn", default=True)
                yt_host.values["banach"] = yt_host.Value(value="Banach")
                yt_host.values["arnold"] = yt_host.Value(value="Arnold")
            yt_tables = sdk2.parameters.Dict("links", sdk2.parameters.String, required=True)

    def on_execute(self):
        yt_token, yt_host = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token), self.Parameters.yt_host

        import yt.wrapper as yt
        yt.config["token"], yt.config["proxy"]["url"] = yt_token, yt_host

        with yt.Transaction():
            for src, dst in self.Parameters.yt_tables.items():
                yt.link(src, dst, force=True)
