import os

from sandbox import sdk2

from sandbox.projects.common.yt_cleaner import get_old_tables

from sandbox.projects.ydo import ydo_releasers, execute_cmd, get_last_released_resource
from sandbox.projects.ydo.backup import YdoBackupBaseTask


class YdoBackupMergeTablesExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoBackupMergeTables(YdoBackupBaseTask):
    class Parameters(sdk2.Parameters):
        history_size = sdk2.parameters.Integer('History size', default=5, required=True)
        with sdk2.parameters.Group('Yt parameters') as yt_block:
            with sdk2.parameters.RadioGroup('Yt host') as yt_host:
                yt_vault_token = sdk2.parameters.String("Your yt token name in vault", default="yt-token", required=True)
                yt_host.values['hahn'] = yt_host.Value(value='Hahn', default=True)
                yt_host.values['banach'] = yt_host.Value(value='Banach')
                yt_host.values["arnold"] = yt_host.Value(value="Arnold")

            path = sdk2.parameters.String('Folder path', required=True)
            merged_path = sdk2.parameters.String('Result path', required=True)

    def on_execute(self):
        yt_token, yt_host = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token), self.Parameters.yt_host
        executable = get_last_released_resource(YdoBackupMergeTablesExecutable)
        cmd = [
            str(executable.path),
            "--output", self.Parameters.merged_path
        ]

        import yt.wrapper as yt
        yt.config["token"], yt.config["proxy"]["url"] = yt_token, yt_host

        old_tables = get_old_tables(yt, self.Parameters.path, self.Parameters.history_size)
        if not old_tables:
            return
        for table in old_tables:
            cmd += ["--table", os.path.join(self.Parameters.path, table)]
        env = os.environ.copy()
        env["YT_TOKEN"], env["YT_PROXY"] = yt_token, yt_host
        execute_cmd(
            cmd,
            "merge_log",
            "Merge failed",
            env=env
        )
