USE %CLUSTER%;

$backup_workers = "%BACKUP_WORKERS%";
$backup_service_cards = "%BACKUP_SERVICE_CARDS%";
$backup_categories = "%BACKUP_CATEGORIES%";
$backup_category_synonyms = "%BACKUP_CATEGORY_SYNONYMS%";
$backup_photos = "%BACKUP_PHOTOS%";

$tag = "%TAG%";
$waiting_for_moderation_status = 0;

$result_workers = "%BACKUP_HOME%/" || $tag || "/workers";
$result_service_cards = "%BACKUP_HOME%/" || $tag || "/service_cards";
$result_categories = "%BACKUP_HOME%/" || $tag || "/categories";
$result_category_synonyms = "%BACKUP_HOME%/" || $tag || "/category_synonyms";
$result_photos = "%BACKUP_HOME%/" || $tag || "/photos";
$result_workers_to_moderation = "%BACKUP_HOME%/" || $tag || "/workers_to_moderation";
$result_puid_to_worker_id = "%BACKUP_HOME%/" || $tag || "/puid_to_worker_id";

INSERT INTO $result_workers
WITH TRUNCATE
SELECT %WORKERS_COLUMNS%
FROM $backup_workers;

INSERT INTO $result_service_cards
WITH TRUNCATE
SELECT %SERVICE_CARDS_COLUMNS%
FROM $backup_service_cards AS service_cards
LEFT SEMI JOIN (
    SELECT DISTINCT id AS worker_id
    FROM $backup_workers
) AS workers
USING (worker_id);

INSERT INTO $result_categories
WITH TRUNCATE
SELECT %CATEGORIES_COLUMNS%
FROM $backup_categories;

INSERT INTO $result_category_synonyms
WITH TRUNCATE
SELECT %CATEGORY_SYNONYMS_COLUMNS%
FROM $backup_category_synonyms;

INSERT INTO $result_photos
WITH TRUNCATE
SELECT %PHOTOS_COLUMNS%
FROM $backup_photos;

INSERT INTO $result_puid_to_worker_id
WITH TRUNCATE
SELECT puid, id
FROM $backup_workers;

COMMIT;

INSERT INTO $result_workers_to_moderation
WITH TRUNCATE
SELECT id, MAX(timestamp) AS timestamp
FROM (
    SELECT id, timestamp
    FROM $result_workers
    WHERE status == $waiting_for_moderation_status
    UNION ALL
    SELECT worker_id AS id, timestamp
    FROM $result_service_cards
    WHERE status == $waiting_for_moderation_status
)
GROUP BY id;

COMMIT;