from sandbox import sdk2

from sandbox.projects.ydo import get_last_released_resource, execute_cmd, YdoDbManagementExecutable


class YdoBackupRestoreFromKikimr(sdk2.Task):
    class Parameters(sdk2.Parameters):
        use_stable_resources = sdk2.parameters.Bool(
            "Use stable resources?",
            default=True,
        )
        with use_stable_resources.value[False]:
            ydo_db_executable = sdk2.parameters.Resource(
                "ydo_db",
                resource_type=YdoDbManagementExecutable,
                required=True,
            )

        server = sdk2.parameters.String("YDB endpoint", required=True)

        database_folder = sdk2.parameters.String("Folder need to restore", required=True)
        backups_folder = sdk2.parameters.String("Backups storage", required=True)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        cmd = [
            str(get_last_released_resource(
                YdoDbManagementExecutable,
                condition=self.Parameters.use_stable_resources,
                default=self.Parameters.ydo_db_executable,
                error_msg="YdoDbManagementExecutable not founded",
            ).path),
            "--server", self.Parameters.server, "--debug",
            "backup",
            "--dir", self.Parameters.database_folder,
            "--backups-storage", self.Parameters.backups_folder,
            "--restore"
        ]

        execute_cmd(cmd, "restore", "restore failed")
