/*
* List of KiKiMR cluster host. 1 hostname could be used, but using several names
* allows to spread the load.
*/
$kikimr_host = AS_LIST(%KIKIMR_HOSTS%);
$kikimr_table_name = "%KIKIMR_TABLE%";
/*
* Kikimr::PushData UDF sends data from YT to KiKiMR in batches
* batch is limited to either bytes or rows
* which comes first
*/
$upload_batch_size_bytes = 5242880;
$upload_batch_size_rows = 10000;
/**
* Sometimes KiKiMR may reply with an error
* In order not to cancel the import process Kikimr::PushData UDF can retry
* failed attempt specified amount of times
*/
$upload_max_retries = 2;
/*
* Interval to wait between reties
*/
$upload_retry_wait_time_sec = 10;


/**
* YT cluster to use
*/
USE %CLUSTER%;

/**
* YQL Pragmas are described in YQL wiki
* https://wiki.yandex-team.ru/yql/userguide/#spisoknastroekpragma
*/
PRAGMA yt.InferSchema;
PRAGMA yt.DataSizePerJob = "209715200";
PRAGMA yt.UserSlots = "20";

SELECT
    SUM(Bytes) AS TotalBytes,
    SUM(Rows) AS TotalRows,
    SUM(Batches) AS TotalBatches,
    SUM(Retries) AS TotalRetries
FROM (
    PROCESS (
    /*
    * YT YQL Query that would produce rows for KiKiMR tables with column names
    * as in KiKiMR table
    */
        SELECT %SCHEMA%
        FROM [%BACKUP_TABLE%] AS t
    )
    USING Kikimr::PushData(
        $ROWS,
        $kikimr_host,
        $kikimr_table_name,
        $upload_batch_size_bytes,
        $upload_batch_size_rows,
        $upload_max_retries,
        $upload_retry_wait_time_sec
    )
);