from sandbox import sdk2

from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view

from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoBackupExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/db/backup_tool/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="ydo_backup")


class YdbBackupExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoBackupYdb(YdoMutlihostTask, SolomonMixinV2):
    class Parameters(generate_view(ydo_backup=YdoBackupExecutable, ydb_backup=YdbBackupExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('YDB'):
            ydb_endpoint = sdk2.parameters.String('Endpoint', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            only_tables = sdk2.parameters.List('Tables to backup (empty for all)')
            blacklisted_tables = sdk2.parameters.List('Tables to skip (empty for none)')
            use_ts_as_table_name = sdk2.parameters.Bool('Use current timestamp as name for backup table (works if only_tables has one table)')
            recursively = sdk2.parameters.Bool('Recursively traverse through Home (works if only_tables has no tables)', default=False)

        with sdk2.parameters.Group('YT'):
            yt_directory = sdk2.parameters.String('Directory', required=True)
            yt_link = sdk2.parameters.String('Path to link for current')
            expired_days = sdk2.parameters.Float('Days before remove')
            prolonging_expired_modifier = sdk2.parameters.Integer('Prolonging modifier', default=10)
            parallel = sdk2.parameters.Integer('Parallel processes count', default=10)

        with sdk2.parameters.Group('Monitoring'):
            monitoring_enabled = sdk2.parameters.Bool('Enable push sensors to solomon', default=False)

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_backup_path, '--debug', 'backup',
            '--backup-tool', self.Parameters.ydb_backup_path,
            '--endpoint', self.Parameters.ydb_endpoint,
            '--database', self.Parameters.ydb_database,
            '--home', self.Parameters.ydb_home,
            '--directory', self.Parameters.yt_directory,
        ]
        if self.Parameters.yt_link:
            cmd += ['--current-link', self.Parameters.yt_link]
        if self.Parameters.expired_days:
            cmd += ['--expired-days', str(self.Parameters.expired_days)]
        if self.Parameters.prolonging_expired_modifier:
            cmd += ['--expired-multiplier-for-first-table-per-day', str(self.Parameters.prolonging_expired_modifier)]
        if self.Parameters.parallel:
            cmd += ['--parallel', str(self.Parameters.parallel)]
        if self.Parameters.only_tables:
            cmd += ['--only-tables']
            for table in self.Parameters.only_tables:
                cmd += [str(table)]
        if self.Parameters.blacklisted_tables:
            cmd += ['--blacklisted-tables']
            for table in self.Parameters.blacklisted_tables:
                cmd += [str(table)]
        if self.Parameters.use_ts_as_table_name:
            cmd += ['--use-ts-as-table-name']
        if self.Parameters.recursively:
            cmd += ['--recursively']

        execute_cmd(cmd, 'backup', 'backup failed', env=self.Parameters.get_environ())

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        sdk2.Task.on_break(self, *args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        sdk2.Task.on_finish(self, *args, **kwargs)
