from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers


class YdoBalanceNotificationsProcessorExecutable(sdk2.Resource):
    """https://nanny.yandex-team.ru/ui/#/services/catalog/ydo_balance_workers/files#balance_notifications_processor
    """
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/payments/balance_notifications_processor/bin"
    binary_path = sdk2.parameters.String(default="balance_notifications_processor")


class YdoProductOrdersProcessorExecutable(sdk2.Resource):
    """https://nanny.yandex-team.ru/ui/#/services/catalog/ydo_balance_workers/files#product_orders_processor
    """
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/payments/product_orders_processor/bin"
    binary_path = sdk2.parameters.String(default="product_orders_processor")


class YdoBalancePaymentsMonitorExecutable(sdk2.Resource):
    """https://nanny.yandex-team.ru/ui/#/services/catalog/ydo_balance_workers/files#monitor
    """
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/payments/monitor/bin"
    binary_path = sdk2.parameters.String(default="monitor")


class YdoBalancePaymentsInspectorExecutable(sdk2.Resource):
    """https://nanny.yandex-team.ru/ui/#/services/catalog/ydo_balance_workers/files#balance_payments_inspector
    """
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/payments/balance_payments_inspector/bin"
    binary_path = sdk2.parameters.String(default="balance_payments_inspector")
