from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoBanFraudWorkersExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoBanFraudWorkers(sdk2.Task, SolomonMixinV2):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_ban_fraud_workers=YdoBanFraudWorkersExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            yt_workers = sdk2.parameters.String('YT workers path', required=True)
            yt_fraud_workers = sdk2.parameters.String('YT fraud_workers path', required=True)
            yt_parsed_passport_data = sdk2.parameters.String('YT parsed_passport_data path', required=True)
            yt_puid2antifraud_glue_id = sdk2.parameters.String('YT puid2antifraud_glue_id path')
            yt_achievements = sdk2.parameters.String('YT achievements path', required=False)
        with sdk2.parameters.Group('IntApi'):
            tvm_id = sdk2.parameters.Integer('TVM id')
            intapi_host = sdk2.parameters.String('IntApi host', choices=[('mock', ''), ('test', 'shared-dev.hamster.yandex.ru'), ('prod', 'ydo-internal.yandex.net')])

        logging_config = sdk2.parameters.String('LoggingConfig')
        min_workers_in_glue = sdk2.parameters.Integer('Min workers in antifraud glue')
        max_workers_in_glue = sdk2.parameters.Integer('Max workers in antifraud glue')
        max_workers_to_delete = sdk2.parameters.Integer('Max workers to delete', required=True)
        delete_partially = sdk2.parameters.Bool('Ban up to max workers', required=True, default=False)

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_ban_fraud_workers_path, 'main',
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),
            '--workers', self.Parameters.yt_workers,
            '--fraud_workers', self.Parameters.yt_fraud_workers,
            '--parsed_passport_data', self.Parameters.yt_parsed_passport_data,

            '--max_workers_to_delete', str(self.Parameters.max_workers_to_delete),
        ]
        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))
        self.add_param_to_cmd(cmd, '--puid2antifraud_glue_id', str(self.Parameters.yt_puid2antifraud_glue_id))
        self.add_param_to_cmd(cmd, '--min_workers_in_glue', str(self.Parameters.min_workers_in_glue))
        self.add_param_to_cmd(cmd, '--max_workers_in_glue', str(self.Parameters.max_workers_in_glue))
        self.add_param_to_cmd(cmd, '--achievements', self.Parameters.yt_achievements)
        self.add_param_to_cmd(cmd, '--tvm-id', str(self.Parameters.tvm_id) if self.Parameters.tvm_id else None)
        self.add_param_to_cmd(cmd, '--ydo-intapi-host', self.Parameters.intapi_host)

        if self.Parameters.delete_partially:
            cmd += ['--delete_partially']

        execute_cmd(cmd, 'ban_fraud_workers', 'ban_fraud_workers failed', env=self.Parameters.get_environ())

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoBanFraudWorkers, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoBanFraudWorkers, self).on_finish(*args, **kwargs)
