import os
import re

from sandbox.projects.common.build.tasks.YaMakeTemplate import YaMakeTemplate, get_project_params

import sandbox.projects.ydo.backup.V3 as backup
import sandbox.projects.ydo.balance_workers as balance_workers_types
import sandbox.projects.ydo.resource_types as ydo_resource_types
import sandbox.projects.ydo.sending_center as sending_center_types
from sandbox.projects.ydo.dispatch.YdoRedispatchOrdersForUndeterminedWorkers import (
    YdoRedispatchOrdersForUndeterminedWorkersExecutable,
)
from sandbox.projects.ydo.erp import (
    YdoErpRegulationsData,
    YdoErpEducationCoursesData,
)
from sandbox.projects.ydo.create_transactions_for_payoffs import YdoCreateTransactionsForPayoffsHandler
from sandbox.projects.ydo.get_payment_batches import YdoGetPaymentBatchesHandler
from sandbox.projects.ydo.erp.CalculateOrdersStatistics import YdoErpOrdersStatisticsCalculator
from sandbox.projects.ydo.erp.MigrateServiceCards import YdoErpMigrateServiceCardsExecutable
from sandbox.projects.ydo.erp.UpdateDefectRate import YdoErpUpdateDefectRateExecutable
from sandbox.projects.ydo.erp.ProcessScheduleConfirmations import YdoErpScheduleConfirmationProcessor
from sandbox.projects.ydo.erp.ProcessTrackMarkupOfScheduleInfoRequestInterval import (
    YdoErpTrackMarkupOfScheduleInfoRequestIntervalProcessor,
)
from sandbox.projects.ydo.erp.UpdateEmployeesCalendars import YdoErpUpdateEmployeesCalendarsProcessor
from sandbox.projects.ydo.return_bottles import YdoReturnBottlesProcessor
from sandbox.projects.ydo.dry_cleaning_mailing_list import YdoDryCleaningMailingListProcessor
from sandbox.projects.ydo.erp.YdoErpServicesSchemasMerger import YdoErpServicesSchemasMergerExecutable
from sandbox.projects.ydo.orders_deficient_commission_processor import YdoOrdersDeficientCommissionProcessor
from sandbox.projects.ydo.replication.ReplicationDiffProcessor import YdoReplicationDiffProcessor
from sandbox.projects.ydo.upload_balance_transactions_to_yt import YdoUploadBalanceTransactionsToYtHandler


class YdoYaMakeTemplate(YaMakeTemplate):
    def get_resources(self):
        resources = {}
        for resource in self.target_resource_classes:
            path_parts = [str(resource), os.path.basename(resource.arcadia_build_path)]
            if not getattr(resource, 'not_single_file', False):
                binary_path = getattr(resource, 'binary_path', os.path.basename(resource.arcadia_build_path))
                path_parts.append(binary_path)

            resources.update(
                {
                    str(resource): {
                        'description': 'Build executable',
                        'resource_path': os.path.join(*path_parts),
                        'resource_type': resource,
                    }
                }
            )

        return resources

    def get_nanny_startrek_ticket_ids(self, additional_parameters):
        release_notes = additional_parameters.get('release_comments', '')
        return list(set(re.findall('[A-Z]+-[1-9][0-9]*', release_notes)))

    def mark_released_resources(self, status, ttl=None):
        if ttl == 'inf':
            ttl = None
        if status == 'stable':
            ttl = ttl or 555
        else:
            ttl = ttl or 14

        return super(YdoYaMakeTemplate, self).mark_released_resources(status, ttl)


class BuildYdoRequestExtractor(YdoYaMakeTemplate):
    class Parameters(get_project_params([ydo_resource_types.YdoRequestExtractor])):
        pass


class BuildYdoMonitorings(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoGolovanAlerts,
                ydo_resource_types.YdoGolovanMenu,
                ydo_resource_types.YdoSolo,
                ydo_resource_types.YdoErrorboosterAlerts,
                ydo_resource_types.YdoAlertsV2Creator,
            ]
        )
    ):
        pass


class BuildYdoApphostSourcesExecutable(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoBackendRequestExtractor,
                ydo_resource_types.YdoBackend,
                ydo_resource_types.YdoImageUploader,
            ]
        )
    ):
        pass


class BuildYdoSendingCenter(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                sending_center_types.YdoSendingCenterExecutable,
                sending_center_types.YdoFastSendingCenterExecutable,
            ]
        )
    ):
        pass


class BuildYdoAsyncApi(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoAsyncApiWorker,
                ydo_resource_types.YdoAsyncApiWorkerConfigs,
                ydo_resource_types.YdoSearchAsyncApiWorkerConfigs,
                ydo_resource_types.YdoReplicationAsyncApiWorkerConfigs,
                ydo_resource_types.YdoAsyncApiSupervisor,
                ydo_resource_types.YdoAsyncApiSupervisorConfigs,
                ydo_resource_types.YdoSearchAsyncApiSupervisorConfigs,
                ydo_resource_types.YdoReplicationAsyncApiSupervisorConfigs,
                ydo_resource_types.YdoAsyncApiInfraConfigs,
            ]
        )
    ):
        pass


# =============================================================================
# balance - workers (cannot declare in separate folder - only __init__ is allowed)
class BuildYdoBalance(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                balance_workers_types.YdoBalanceNotificationsProcessorExecutable,
                balance_workers_types.YdoProductOrdersProcessorExecutable,
                balance_workers_types.YdoBalancePaymentsMonitorExecutable,
                balance_workers_types.YdoBalancePaymentsInspectorExecutable,
            ]
        )
    ):
        pass


class BuildYdoBgTaskProcessor(YdoYaMakeTemplate):
    class Parameters(get_project_params([ydo_resource_types.YdoBgTaskProcessor])):
        pass


class BuildYdoLogbrokerDelivery(YdoYaMakeTemplate):
    class Parameters(get_project_params([ydo_resource_types.YdoLogbrokerDelivery])):
        pass


class BuildYdoYtMonthlyMergerExecutable(YdoYaMakeTemplate):
    class Parameters(get_project_params([ydo_resource_types.YdoYtMonthlyMergerExecutable])):
        pass


class BuildYdoERPBackend(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoERPBackend,
                ydo_resource_types.YdoERPBackendConfigs,
                ydo_resource_types.YdoERPBackendInfraConfigs,
                ydo_resource_types.YdoERPBackendOrderStateGraphs,
                ydo_resource_types.YdoERPBackendRegionPresets,
                ydo_resource_types.YdoCppERPBackend,
                ydo_resource_types.YdoCppERPBackendConfigs,
            ]
        )
    ):
        pass


class BuildYdoBackupExecutable(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                backup.YdoBackupExecutable,
            ]
        )
    ):
        pass


class BuildYdoDispatch(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoDispatch,
            ]
        )
    ):
        pass


class BuildYdoDevopsDaemons(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoDevopsDaemonReloader,
            ]
        )
    ):
        pass


class BuildYdoErpOrdersStatisticsCalculator(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpOrdersStatisticsCalculator,
            ]
        )
    ):
        pass


class BuildYdoCreateTransactionsForPayoffsHandler(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoCreateTransactionsForPayoffsHandler,
            ]
        )
    ):
        pass


class BuildYdoUploadBalanceTransactionsToYtHandler(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoUploadBalanceTransactionsToYtHandler,
            ]
        )
    ):
        pass


class BuildYdoGetPaymentBatchesHandler(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoGetPaymentBatchesHandler,
            ]
        )
    ):
        pass


class BuildYdoReturnBottlesProcessor(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoReturnBottlesProcessor,
            ]
        )
    ):
        pass


class BuildYdoDryCleaningMailingListProcessor(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoDryCleaningMailingListProcessor,
            ]
        )
    ):
        pass


class BuildYdoErpScheduleConfirmationProcessor(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpScheduleConfirmationProcessor,
            ]
        )
    ):
        pass


class BuildYdoErpTrackMarkupOfScheduleInfoRequestIntervalProcessor(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpTrackMarkupOfScheduleInfoRequestIntervalProcessor,
            ]
        )
    ):
        pass


class BuildYdoErpMigrateServiceCardsExecutable(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpMigrateServiceCardsExecutable,
            ]
        )
    ):
        pass


class BuildYdoErpUpdateDefectRateExecutable(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpUpdateDefectRateExecutable,
            ]
        )
    ):
        pass


class BuildYdoErpServicesSchemasMergerExecutable(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpServicesSchemasMergerExecutable,
            ]
        )
    ):
        pass


class BuildYdoOrdersDeficientCommissionProcessorExecutable(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoOrdersDeficientCommissionProcessor,
            ]
        )
    ):
        pass


class BuildYdoErpUpdateEmployeesCalendarsProcessor(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                YdoErpUpdateEmployeesCalendarsProcessor,
            ]
        )
    ):
        pass


class BuildYdoBackendRenderer(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoBackendRenderer,
                ydo_resource_types.YdoBackendRendererConfigs,
                ydo_resource_types.YdoBackendRendererInfraConfigs,
            ]
        )
    ):
        pass


class BuildYdoDispatchShooter(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoDispatchShooterExecutable,
                ydo_resource_types.YdoDispatchShooterConfigs,
            ]
        )
    ):
        pass


class BuildYdoRedispatcher(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoRedispatcherExecutable,
                ydo_resource_types.YdoRedispatcherConfigs,
            ]
        )
    ):
        pass


class BuildYdoRedispatcherMonitoring(YdoYaMakeTemplate):
    class Parameters(get_project_params([ydo_resource_types.YdoRedispatcherMonitoringExecutable])):
        pass


class BuildYdoDispatchCacheIndexer(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoDispatchCacheIndexerExecutable,
                ydo_resource_types.YdoDispatchCacheIndexerConfigs,
            ]
        )
    ):
        pass


class BuildYdoCacheShooter(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoCacheShooterExecutable,
                ydo_resource_types.YdoCacheShooterConfigs,
            ]
        )
    ):
        pass


class BuildYdoTestMarketPackages(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoTestMarketExecutable,
                ydo_resource_types.YdoDispatchShooterConfigs,
            ]
        )
    ):
        pass


class BuildYdoRedispatchOrdersForUndeterminedWorkersExecutable(YdoYaMakeTemplate):
    class Parameters(get_project_params([YdoRedispatchOrdersForUndeterminedWorkersExecutable])):
        pass


class BuildYdoErpRegulationsData(YdoYaMakeTemplate):
    class Parameters(get_project_params([YdoErpRegulationsData])):
        pass


class BuildYdoErpEducationCoursesData(YdoYaMakeTemplate):
    class Parameters(get_project_params([YdoErpEducationCoursesData])):
        pass


class BuildYdoReplicationDiffProcessor(YdoYaMakeTemplate):
    class Parameters(get_project_params([YdoReplicationDiffProcessor])):
        pass


class BuildYdoServiceModelSitemapGenerator(YdoYaMakeTemplate):
    class Parameters(
        get_project_params(
            [
                ydo_resource_types.YdoGenerateServiceModelSitemapExecutable,
            ]
        )
    ):
        pass


class BuildYdoResponseTimingsToSolomon(YdoYaMakeTemplate):
    class Parameters(get_project_params([ydo_resource_types.YdoResponseTimingsToSolomon])):
        pass
